<?php

/*

Template Name: Contact

*/

// Main
$main_class = is_active_sidebar( 'contact' ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>">

					<?php if ( have_posts() ) {
						while ( have_posts() ) {
							the_post();

							get_template_part( 'templates/page/content' );

						}
					}

					if ( shortcode_exists( 'forqy-form-contact' ) ) {
						echo do_shortcode( '[forqy-form-contact]' );
					} ?>

                </main>

				<?php if ( is_active_sidebar( 'contact' ) ) {
					get_sidebar( 'contact' );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
