<?php

/*

Ingredient Taxonomy Template

*/

// Type
$type = 'menu';

// Taxonomy
$taxonomy = 'section';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading', 'term' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?><?php if ( get_theme_mod( 'fy_menu_single' ) != 'enabled' ) { ?> js-images<?php } ?>"
                      itemscope itemtype="https://schema.org/MenuSection">

					<?php
					/**
					 * Terms Query
					 */
					$term      = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
					$term_slug = is_object( $term ) ? $term->slug : $term['slug'];

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					$query = new WP_Query( array(
						'post_type'           => $type,
						'tax_query'           => array(
							array(
								'taxonomy'         => $taxonomy,
								'terms'            => $term->slug,
								'field'            => 'slug',
								'include_children' => 0
							)
						),
						'post_status'         => 'publish',
						'order'               => 'ASC',
						'orderby'             => 'date',
						'ignore_sticky_posts' => 1,
						'paged'               => $paged,
						'posts_per_page'      => - 1
					) );

					if ( $query->have_posts() ) { ?>
                        <div class="fy-flex-container fy-flex-gutter-large">
							<?php while ( $query->have_posts() ) { ?>
								<?php $query->the_post(); ?>

                                <div class="fy-post-column<?php if ( is_active_sidebar( 'menu' ) ) { ?> fy-flex-column-100<?php } else { ?> fy-flex-column-50<?php } ?> fy-flex-column-tablet-100">
									<?php get_template_part( 'content', $type ); ?>
                                </div>

							<?php } ?>
                        </div>

						<?php
						wp_reset_postdata();
					}

					/**
					 * Get Children
					 */

					$children = get_terms( array(
						'taxonomy' => $taxonomy,
						'child_of' => $term->term_id,
						'order'    => 'ASC',
						'orderby'  => 'date',
					) );

					foreach ( $children as $child ) {

						/**
						 * Child Query
						 */
						$query_child = new WP_Query( array(
							'post_type'           => $type,
							'tax_query'           => array(
								array(
									'taxonomy'         => $taxonomy,
									'terms'            => $child->slug,
									'field'            => 'slug',
									'include_children' => 0
								)
							),
							'post_status'         => 'publish',
							'order'               => 'ASC',
							'orderby'             => 'date',
							'ignore_sticky_posts' => 1,
							'posts_per_page'      => - 1
						) );
						?>

                        <section class="fy-term-item">

							<?php if ( $query_child->have_posts() ) { ?>
                                <header class="fy-child-header">
                                    <h3><?php echo esc_html( $child->name ); ?></h3>

									<?php if ( ! empty( $child->description ) ) { ?>
                                        <div class="fy-child-description">
											<?php echo wp_kses( $child->description, array(
												'a'      => array(
													'href'   => array(),
													'target' => array()
												),
												'br'     => array(),
												'em'     => array(),
												'strong' => array()
											) ); ?>
                                        </div>
									<?php } ?>
                                </header>

                                <div class="fy-flex-container fy-flex-container-stretch fy-flex-gutter-large">
									<?php while ( $query_child->have_posts() ) {
										$query_child->the_post(); ?>

                                        <div class="<?php if ( is_active_sidebar( $type ) ) { ?> fy-flex-column-100 <?php } else { ?> fy-flex-column-50<?php } ?> fy-flex-column-tablet-100">
											<?php get_template_part( 'content', $type ); ?>
                                        </div>

									<?php } ?>
                                </div>
							<?php } ?>

                        </section>
					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
					get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
