<?php

/*

Ingredient Taxonomy Template

*/

// Type
$type = 'menu';

// Taxonomy
$taxonomy = 'ingredient';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

global $index;

get_header();
get_template_part( 'heading', 'term' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>"  itemscope itemtype="https://schema.org/MenuSection">

					<?php if ( term_description() ) { ?>
                        <div class="fy-page-content fy-content">
							<?php echo term_description(); ?>
                        </div>
					<?php }

					// Get Terms
					$term      = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
					$term_slug = is_object( $term ) ? $term->slug : $term['slug'];

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					$query = new WP_Query( array(
						'post_type'           => $type,
						'taxonomy'            => $taxonomy,
						'term'                => $term_slug,
						'post_status'         => 'publish',
						'order'               => 'ASC',
						'orderby'             => 'date',
						'ignore_sticky_posts' => 1,
						'paged'               => $paged,
						'posts_per_page'      => - 1
					) );

					if ( $query->have_posts() ) { ?>
                        <div class="fy-flex-container fy-flex-gutter-large<?php if ( get_theme_mod( 'fy_menu_single' ) != 'enabled' ) { ?> js-images<?php } ?>">
							<?php while ( $query->have_posts() ) {
							    $query->the_post(); ?>

                                <div class="fy-flex-column-50 fy-flex-column-tablet-100">
									<?php get_template_part( 'content', $type ); ?>
                                </div>

								<?php $index ++;
							} ?>
                        </div>

						<?php
                        wp_reset_postdata();
					} else { ?>

                        <div class="fy-page-content fy-content fy-content-empty">
							<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                        </div>

					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
				    get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
