<?php

/*

Gallery Taxonomy Template

*/

// Type
$type = 'gallery';

// Taxonomy
$taxonomy = 'category-gallery';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading', 'term' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-main-gallery fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>"
                      itemscope
                      itemtype="https://schema.org/ImageGallery">

					<?php if ( term_description() ) { ?>
                        <div class="fy-page-content fy-content">
							<?php echo term_description(); ?>
                        </div>
					<?php } ?>

					<?php
					// Get Terms
					$term      = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
					$term_slug = is_object( $term ) ? $term->slug : $term['slug'];

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					$args  = array(
						'post_type'           => $type,
						'taxonomy'            => $taxonomy,
						'term'                => $term_slug,
						'post_status'         => 'publish',
						'order'               => 'DESC',
						'orderby'             => 'date',
						'ignore_sticky_posts' => 1,
						'paged'               => $paged,
						'posts_per_page'      => get_option( 'posts_per_page' )
					);
					$query = new WP_Query( $args );

					$i = 0;

					if ( $query->have_posts() ) { ?>
                        <div class="fy-flex-container fy-flex-gutter-large">
							<?php while ( $query->have_posts() ) {
							    $query->the_post(); ?>

                                <div class="fy-post-column fy-post-column-<?php echo esc_attr( $i ); ?><?php if ( is_active_sidebar( $type ) ) { ?> fy-flex-column-50 fy-flex-column-tablet-100<?php } else { ?> fy-flex-column-33 fy-flex-column-tablet-50<?php } ?> fy-flex-column-phone-100">

									<?php get_template_part( 'content', $type ); ?>

                                </div>

								<?php
                                $i ++;
							} ?>
                        </div>

						<?php
                        if ( function_exists( 'linguini_pagination' ) ) {
							linguini_pagination( $query->max_num_pages, '', $paged );
						}

                        wp_reset_postdata();
					} else { ?>

                        <div class="fy-page-content fy-content fy-content-empty">
							<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                        </div>

					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
				    get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
