<?php

/*

Event Taxonomy Template

*/

// Type
$type = 'event';

// Taxonomy
$taxonomy = 'category-event';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading', 'term' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-main-event fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>" itemscope itemtype="https://schema.org/Event">

					<?php if ( term_description() ) { ?>
                        <div class="fy-page-content">
							<?php echo term_description(); ?>
                        </div>
					<?php }

					// Get Terms
					$term      = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
					$term_slug = is_object( $term ) ? $term->slug : $term['slug'];

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					$query = new WP_Query( array(
						'post_type'           => $type,
						'taxonomy'            => $taxonomy,
						'term'                => $term_slug,
						'meta_key'            => 'fy_event_date',
						'meta_value'          => date( 'Y/m/d' ),
						'meta_compare'        => '>=',
						'order'               => 'ASC',
						'orderby'             => 'meta_value',
						'ignore_sticky_posts' => 1,
						'paged'               => $paged,
						'posts_per_page'      => get_option( 'posts_per_page' )
					) );

					if ( $query->have_posts() ) {
						while ( $query->have_posts() ) {
							$query->the_post();

							get_template_part( 'content', $type );

						}

						if ( function_exists( 'linguini_pagination' ) ) {
							linguini_pagination( $query->max_num_pages, '', $paged );
						}

						wp_reset_postdata();
					} else { ?>

                        <div class="fy-page-content fy-content fy-content-empty">
							<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                        </div>

					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
					get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
