<?php

/*

Single Event Template

*/

// Type
$type = 'event';

// Main Class
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-main-single fy-single-event fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>" itemscope itemtype="https://schema.org/Event">

					<?php if ( have_posts() ) {
					    while ( have_posts() ) {
					        the_post();

					        if ( get_post_type() != 'post' ) {
					            get_template_part( 'content', get_post_type() . '-single' );
					        } else if ( get_post_type() == 'post' ) {

					            if ( get_post_format() ) {
					                get_template_part( 'content', get_post_format() . '-single' );
					            } else {
					                get_template_part( 'content', 'standard-single' );
					            }

					        }

					    }
					}

					if ( comments_open() || get_comments_number() ) {
					    comments_template();
					} ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
				    get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
