<?php

/*

Search Template

*/

get_header();
?>
    <header class="fy-heading">
        <div class="fy-centerer">

			<?php
			global $wp_query;
			$total_results = $wp_query->found_posts;
			?>
            <h1><?php printf( esc_html__( '%s results for \'%s\'', 'linguini' ), $total_results, get_search_query() ); ?></h1>

        </div>
    </header>

    <div class="fy-wrap">

        <div class="fy-centerer">

            <main class="fy-main fy-sidebar-inactive">

				<?php
				global $query_string;

				$query_args   = explode( "&", $query_string );
				$search_query = array();

				if ( strlen( $query_string ) > 0 ) {
					foreach ( $query_args as $key => $string ) {
						$query_split                     = explode( "=", $string );
						$search_query[ $query_split[0] ] = urldecode( $query_split[1] );
					} // foreach
				} //if

				$search = new WP_Query( $search_query );

				if ( $search->have_posts() ) {
					while ( $search->have_posts() ) {
						$search->the_post();

						get_template_part( 'content', 'search' );

					}

					if ( function_exists( 'linguini_paginate_links' ) ) {
						linguini_paginate_links();
					}
				} else { ?>

                    <div class="fy-centerer-50">
                        <h4 class="fy-margin-bottom">
							<?php esc_html_e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'linguini' ); ?>
                        </h4>

						<?php get_search_form(); ?>
                    </div>

				<?php } ?>

            </main>

        </div>

    </div>

<?php
get_footer();
