<?php

/*

Comments

*/

/*
====================================================================================================
Comments List
====================================================================================================
*/

if ( ! function_exists( 'forqy_comments_list' ) ) {

	function forqy_comments_list( $comment, $args, $depth ) {
		$globals['comment'] = $comment;

		// Avatar
		$avatar = get_avatar( $comment );
		?>

    <div <?php comment_class( 'fy-comment' ); ?>>

        <article id="fy-comment-<?php comment_ID(); ?>"  itemscope itemtype="https://schema.org/Comment">

            <div class="fy-comment-body">

                <header class="fy-comment-header">
                    <div class="fy-flex-container fy-flex-container-center fy-flex-gutter-small">

						<?php if ( ! empty( $avatar ) ) { ?>
                            <div class="fy-flex-column">
                                <div class="fy-comment-avatar">
									<?php echo get_avatar( $comment, $size = '96' ); ?>
                                </div>
                            </div>
						<?php } ?>

                        <div class="fy-flex-column-auto">

                            <h5 class="fy-comment-author" itemprop="name">
								<?php echo get_comment_author_link(); ?>
                            </h5>

                            <div class="fy-comment-meta">
                                <time class="fy-comment-date" datetime="<?php comment_time( 'c' ); ?>">
                                    <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
										<?php printf( esc_html__( '%1$s at %2$s', 'linguini' ), get_comment_date(), get_comment_time() ); ?></a>
                                </time>
                            </div>

                        </div>
                        <div class="fy-flex-column">

                            <div class="fy-comment-toolbar">
                                <div class="fy-flex-container fy-flex-container-center fy-flex-gutter-small">
                                    <div class="fy-flex-column-auto fy-flex-column-phone-100">

                                        <div class="fy-comment-reply">
											<?php comment_reply_link( array_merge( $args, array(
												'depth'     => $depth,
												'max_depth' => $args['max_depth']
											) ) ); ?>
                                        </div>

                                    </div>
									<?php if ( current_user_can( 'edit_comment', $comment->comment_ID ) ) { ?>
                                        <div class="fy-flex-column-auto fy-flex-column-phone-100">

                                            <div class="fy-comment-edit">
												<?php edit_comment_link( esc_html__( 'Edit', 'linguini' ), '', '' ); ?>
                                            </div>

                                        </div>
									<?php } ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </header>

				<?php if ( $comment->comment_approved == '0' ) { ?>
                    <div class="fy-alert fy-margin-top">
						<?php esc_html_e( 'Your comment is awaiting moderation.', 'linguini' ); ?>
                    </div>
				<?php } ?>

                <div class="fy-comment-content fy-content" itemprop="text">
					<?php comment_text() ?>
                </div>
            </div>
        </article>

		<?php
	}

}