/*jslint browser this:true */
/*global window, jQuery, Pace */

/**
 * Theme
 * @version 1.0.1
 * @requires jQuery
 */

(function ($) {
    "use strict";

    /**
     * Loading
     */

    const loading = $(".js-page-loading");

    Pace.on("done", function () {
        loading.addClass("loading-hiding");

        if (loading.hasClass("loading-hiding")) {
            setTimeout(function () {
                loading.removeClass("loading-hiding");
                loading.addClass("loading-hidden");
            }, 600);
        }
    });

    /**
     * Slideshow Height
     */

    function linguiniSlideshowHeight() {

        const slideshow = $(".js-slideshow-height");
        const windowHeight = $(window).innerHeight();
        const headerHeight = $(".js-header").innerHeight();

        slideshow.css("height", windowHeight - headerHeight);

        if ($("body").hasClass("admin-bar")) {
            slideshow.css("height", windowHeight - headerHeight - 32);
        }

    }

    linguiniSlideshowHeight();

    $(window).on("resize", function () {
        linguiniSlideshowHeight();
    });

}(jQuery));