/*jslint browser this:true long:true */
/*global window, jQuery */

/**
 * Sticky
 * @version 1.0.1
 * @requires jQuery, Double Tap to Go
 */

(function ($) {
    "use strict";

    const CLASS_STICKY_STUCK = "is-stuck";

    const body = $("body");
    const adminBar = $("#wpadminbar");
    const adminBarHeight = adminBar.innerHeight();

    // sticky navigation
    const stickyNavigation = $(".js-sticky");
    const stickyNavigationHeight = stickyNavigation.innerHeight();

    // sticky navigation menu
    const stickyNavigationMenu = $(".js-sticky-menu");

    const doc = $(document);

    /**
     * Stick It
     */

    function linguiniStickIt(selector, offset, BODY_STICKY_CLASS) {

        if (selector.length) {

            const currentTop = doc.scrollTop();

            if (currentTop >= offset) {
                selector.addClass(CLASS_STICKY_STUCK);
                body.addClass(BODY_STICKY_CLASS);
            } else {
                selector.removeClass(CLASS_STICKY_STUCK);
                body.removeClass(BODY_STICKY_CLASS);
            }

        }

    }

    // stick navigation
    if (stickyNavigation.length) {

        const stickyNavigationTop = (
            body.hasClass("admin-bar")
            ? stickyNavigation.offset().top - adminBarHeight
            : stickyNavigation.offset().top
        );

        if (body.innerWidth() >= "1024") {
            linguiniStickIt(stickyNavigation, stickyNavigationTop, "navigation-is-stuck");
        }

        // on scroll
        $(window).on("scroll touchmove resize", function () {
            if (body.innerWidth() >= "1024") {
                linguiniStickIt(stickyNavigation, stickyNavigationTop, "navigation-is-stuck");
            }
        });

    }

    // stick navigation - menu
    if (stickyNavigationMenu.length) {

        const stickyNavigationMenuTop = (
            body.hasClass("admin-bar")
            ? stickyNavigationMenu.offset().top - stickyNavigationHeight - adminBarHeight
            : stickyNavigationMenu.offset().top - stickyNavigationHeight
        );
        const stickyNavigationMenuTopMobile = (
            body.hasClass("admin-bar")
            ? stickyNavigationMenu.offset().top - adminBarHeight
            : stickyNavigationMenu.offset().top
        );

        if (body.innerWidth() >= "1024") {
            linguiniStickIt(stickyNavigationMenu, stickyNavigationMenuTop, "navigation-menu-is-stuck");
        } else {
            linguiniStickIt(stickyNavigationMenu, stickyNavigationMenuTopMobile, "navigation-menu-is-stuck");
        }

        // on scroll
        $(window).on("scroll touchmove resize", function () {

            const stickyNavigationMenuTopMobileUpdated = (
                body.hasClass("admin-bar")
                ? stickyNavigationMenu.offset().top - adminBarHeight
                : stickyNavigationMenu.offset().top
            );

            if (body.innerWidth() >= "1024") {
                linguiniStickIt(stickyNavigationMenu, stickyNavigationMenuTop, "navigation-menu-is-stuck");
            } else {
                linguiniStickIt(stickyNavigationMenu, stickyNavigationMenuTopMobileUpdated, "navigation-menu-is-stuck");
            }

        });
    }

    /**
     * Scroll Active
     * */

    const menuItems = stickyNavigationMenu.find("a");

    // anchors corresponding to menu items
    const scrollItems = menuItems.map(function () {
        const item = $($(this).attr("href"));

        if (item.length) {
            return item;
        }
    });

    // bind to scroll
    $(window).on("scroll touchmove", function () {

        if (stickyNavigationMenu.hasClass(CLASS_STICKY_STUCK)) {

            // get container scroll position
            const fromTop = $(this).scrollTop() + 80;

            // get id of current scroll item
            let cur = scrollItems.map(function () {
                if ($(this).offset().top < fromTop) {
                    return this;
                }
            });

            // get the id of the current element
            cur = cur[cur.length - 1];
            const id = cur && (
                cur.length
                ? cur[0].id
                : ""
            );

            // set/remove active class
            menuItems.parent().removeClass("active").end().filter("[href='#" + id + "']").parent().addClass("active");

        } else {
            menuItems.parent().removeClass("active");
        }

    });

}(jQuery));