/*jslint browser */
/*global window, jQuery */

/**
 * Navigation
 * @version 1.0.1
 * @requires jQuery, Double Tap to Go
 */

(function ($) {
    "use strict";

    const html = $("html");
    const body = $("body");

    /**
     * DoubleTapToGo
     */

    function linguiniInitDTTG() {

        if (body.innerWidth() >= "1024") {
            $(".fy-navigation li:has(ul)").doubleTapToGo();
        }

    }

    linguiniInitDTTG();

    $(window).on("resize", function () {
        linguiniInitDTTG();
    });

    /**
     * Navigation
     */

    const trigger = $(".js-navigation-trigger");

    trigger.each(function (ignore, el) {

        $(el).on("click touchstart", function (e) {
            e.preventDefault();

            if (body.hasClass("navigation-active")) {
                body.addClass("navigation-closing");

                setTimeout(function () {
                    html.removeClass("navigation-active");

                    body.removeClass("navigation-closing");
                    body.removeClass("navigation-active");
                }, 300);
            } else {
                html.addClass("navigation-active");
                body.addClass("navigation-active");
            }

        });

    });

    // close navigation

    const closer = $(".js-navigation-close");

    closer.each(function (ignore, el) {

        $(el).on("click touchstart", function () {

            if (body.hasClass("navigation-active")) {

                body.addClass("navigation-closing");

                setTimeout(function () {
                    html.removeClass("navigation-active");

                    body.removeClass("navigation-closing");
                    body.removeClass("navigation-active");
                }, 300);
            }

        });

    });

    // close navigation on esc

    $(document).keyup(function (e) {

        if (e.key === "Escape") {

            if (body.hasClass("navigation-active")) {
                body.addClass("navigation-closing");

                setTimeout(function () {
                    html.removeClass("navigation-active");

                    body.removeClass("navigation-closing");
                    body.removeClass("navigation-active");
                }, 300);
            }

        }

    });

    /**
     * Anchor Links
     */

    const navigationAnchorLink = $(".fy-navigation a[href='#']");

    navigationAnchorLink.on("click", function (e) {
        e.preventDefault();
    });

}(jQuery));