<?php

/*

Index Template

*/

// Get Page for Posts
$title   = get_the_title( get_option( 'page_for_posts', true ) );
$content = apply_filters( 'the_content', get_post_field( 'post_content', get_option( 'page_for_posts' ) ) );

// Main
$main_class = is_active_sidebar( 'blog' ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading', 'index' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>">

					<?php
					$i = 0;

					if ( have_posts() ) { ?>
                        <div class="fy-flex-container fy-flex-gutter-large">
							<?php while ( have_posts() ) {
								the_post(); ?>

                                <div class="fy-post-column fy-post-column-<?php echo esc_attr( $i ); ?><?php if ( is_active_sidebar( 'blog' ) ) { ?> fy-flex-column-50 fy-flex-column-tablet-100<?php } else { ?> fy-flex-column-33 fy-flex-column-tablet-50<?php } ?> fy-flex-column-phone-100">

									<?php if ( get_post_type() != 'post' ) {
										get_template_part( 'content', get_post_type() );
									} else if ( get_post_type() == 'post' ) {

										if ( get_post_format() ) {
											get_template_part( 'content', get_post_format() );
										} else {
											get_template_part( 'content', 'standard' );
										}

									} ?>

                                </div>

								<?php
								$i ++;
							} ?>
                        </div>

						<?php
						if ( function_exists( 'linguini_pagination' ) ) {
							linguini_pagination();
						}
					} else { ?>

                        <div class="fy-page-content fy-content fy-content-empty">
							<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                        </div>

					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( 'blog' ) ) {
					get_sidebar( 'blog' );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();