<?php

/*

Subpages Widget

*/

class fy_Widget_Subpages extends WP_Widget {

	public function __construct() {

		$widget_options = array(
			'classname'          => 'widget_pages widget_subpages',
			'description'        => esc_html__( 'A widget displays the sub-pages of the current page. Widget only appears if there are sub-pages of the current page.', 'linguini' ),
			'customizer_support' => true,
		);

		parent::__construct( 'widget_subpages', FORQY_THEME_NAME . ': ' . esc_html__( 'Sub-pages', 'linguini' ), $widget_options );

	}

	function widget( $args, $instance ) {

		extract( $args );

		$widget_title = apply_filters( 'widget_title', $instance['widget_title'] );

		if ( ! is_page() ) {
			return;
		}

		$post = get_queried_object();

		if ( 0 >= $post->post_parent ) {
			$children = wp_list_pages( array(
				'child_of' => get_queried_object_id(),
				'echo'     => false,
				'title_li' => false
			) );
		} else if ( $post->ancestors ) {
			$ancestors = $post->ancestors;
			$ancestors = end( $ancestors );
			$children  = wp_list_pages( array( 'child_of' => $ancestors, 'title_li' => false, 'echo' => false ) );
		}

		if ( empty( $children ) ) {
			return;
		}

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		}
		?>

        <ul>
			<?php echo $children; ?>
        </ul>

		<?php
		echo $args['after_widget'];

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance = $new_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );

		return $instance;

	}

	function form( $instance ) {

		$defaults = array(
			'widget_title' => esc_html__( 'Sub-pages', 'linguini' )
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$widget_title = isset( $instance['widget_title'] ) ? esc_html( $instance['widget_title'] ) : '';

		?>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_title' ); ?>">
				<?php esc_html_e( 'Title:', 'linguini' ); ?>
            </label>

            <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'widget_title' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_title' ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">

        </p>

		<?php
	}

}