<?php

/*

Opening Hours Widget

*/

class fy_Widget_Opening_Hours extends WP_Widget {

	public function __construct() {

		$widget_options = array(
			'classname'          => 'widget_opening_hours',
			'description'        => esc_html__( 'A widget displays opening hours of your restaurant.', 'linguini' ),
			'customizer_support' => true,
		);

		parent::__construct( 'widget_opening_hours', FORQY_THEME_NAME . ': ' . esc_html__( 'Opening Hours', 'linguini' ), $widget_options );

	}

	function widget( $args, $instance ) {

		// Vars
		$widget_title   = apply_filters( 'widget_title', $instance['widget_title'] );
		$widget_content = apply_filters( 'widget_text', $instance['widget_content'] );

		$monday    = $instance['monday'];
		$tuesday   = $instance['tuesday'];
		$wednesday = $instance['wednesday'];
		$thursday  = $instance['thursday'];
		$friday    = $instance['friday'];
		$saturday  = $instance['saturday'];
		$sunday    = $instance['sunday'];

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		}

		if ( $widget_content ) {
			?>

            <div class="fy-widget-content">
				<?php echo do_shortcode( wpautop( $widget_content ) ); ?>
            </div>

			<?php
		}

		if ( ! empty( $monday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Monday', 'linguini' ); ?> <?php echo esc_attr( $monday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Monday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $monday ); ?></span></div>
			<?php
		}
		if ( ! empty( $tuesday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Tuesday', 'linguini' ); ?> <?php echo esc_attr( $tuesday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Tuesday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $tuesday ); ?></span></div>
			<?php
		}
		if ( ! empty( $wednesday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Wednesday', 'linguini' ); ?> <?php echo esc_attr( $wednesday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Wednesday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $wednesday ); ?></span></div>
			<?php
		}
		if ( ! empty( $thursday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Thursday', 'linguini' ); ?> <?php echo esc_attr( $thursday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Thursday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $thursday ); ?></span></div>
			<?php
		}
		if ( ! empty( $friday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Friday', 'linguini' ); ?> <?php echo esc_attr( $friday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Friday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $friday ); ?></span></div>
			<?php
		}
		if ( ! empty( $saturday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Saturday', 'linguini' ); ?> <?php echo esc_attr( $saturday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Saturday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $saturday ); ?></span></div>
			<?php
		}
		if ( ! empty( $sunday ) ) {
			?>
            <div class="fy-day"
                 content="<?php esc_attr_e( 'Sunday', 'linguini' ); ?> <?php echo esc_attr( $sunday ); ?>">
                <strong class="fy-float-left"><?php esc_html_e( 'Sunday', 'linguini' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $sunday ); ?></span></div>
			<?php
		}

		echo $args['after_widget'];

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance = $new_instance;

		$instance['widget_title']   = strip_tags( $new_instance['widget_title'] );
		$instance['widget_content'] = $new_instance['widget_content'];

		$instance['monday']    = $new_instance['monday'];
		$instance['tuesday']   = $new_instance['tuesday'];
		$instance['wednesday'] = $new_instance['wednesday'];
		$instance['thursday']  = $new_instance['thursday'];
		$instance['friday']    = $new_instance['friday'];
		$instance['saturday']  = $new_instance['saturday'];
		$instance['sunday']    = $new_instance['sunday'];


		return $instance;

	}

	function form( $instance ) {

		$defaults = array(
			'widget_title' => esc_html__( 'Opening hours', 'linguini' ),
			'monday'       => esc_html__( 'Closed', 'linguini' ),
			'tuesday'      => esc_html__( '10:00 AM - 11:00 PM', 'linguini' ),
			'wednesday'    => esc_html__( '10:00 AM - 11:00 PM', 'linguini' ),
			'thursday'     => esc_html__( '10:00 AM - 11:00 PM', 'linguini' ),
			'friday'       => esc_html__( '10:00 AM - 11:00 PM', 'linguini' ),
			'saturday'     => esc_html__( '10:00 AM - 11:00 PM', 'linguini' ),
			'sunday'       => esc_html__( '10:00 AM - 11:00 PM', 'linguini' ),
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$widget_title   = isset( $instance['widget_title'] ) ? esc_html( $instance['widget_title'] ) : '';
		$widget_content = isset( $instance['widget_content'] ) ? esc_html( $instance['widget_content'] ) : '';

		$monday    = isset( $instance['monday'] ) ? esc_html( $instance['monday'] ) : '';
		$tuesday   = isset( $instance['tuesday'] ) ? esc_html( $instance['tuesday'] ) : '';
		$wednesday = isset( $instance['wednesday'] ) ? esc_html( $instance['wednesday'] ) : '';
		$thursday  = isset( $instance['thursday'] ) ? esc_html( $instance['thursday'] ) : '';
		$friday    = isset( $instance['friday'] ) ? esc_html( $instance['friday'] ) : '';
		$saturday  = isset( $instance['saturday'] ) ? esc_html( $instance['saturday'] ) : '';
		$sunday    = isset( $instance['sunday'] ) ? esc_html( $instance['sunday'] ) : '';

		?>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_title' ); ?>">
				<?php esc_html_e( 'Title:', 'linguini' ); ?></label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_title' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_title' ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'widget_content' ); ?>">
				<?php esc_html_e( 'Content:', 'linguini' ); ?></label>

            <textarea class="widefat" rows="12" cols="20"
                      id="<?php echo $this->get_field_id( 'widget_content' ); ?>"
                      name="<?php echo $this->get_field_name( 'widget_content' ); ?>"><?php echo esc_html( $widget_content ); ?></textarea>

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'monday' ); ?>">
				<?php esc_html_e( 'Monday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'monday' ); ?>"
                   name="<?php echo $this->get_field_name( 'monday' ); ?>"
                   value="<?php echo esc_attr( $monday ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'tuesday' ); ?>">
				<?php esc_html_e( 'Tuesday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'tuesday' ); ?>"
                   name="<?php echo $this->get_field_name( 'tuesday' ); ?>"
                   value="<?php echo esc_attr( $tuesday ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'wednesday' ); ?>">
				<?php esc_html_e( 'Wednesday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'wednesday' ); ?>"
                   name="<?php echo $this->get_field_name( 'wednesday' ); ?>"
                   value="<?php echo esc_attr( $wednesday ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'thursday' ); ?>">
				<?php esc_html_e( 'Thursday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'thursday' ); ?>"
                   name="<?php echo $this->get_field_name( 'thursday' ); ?>"
                   value="<?php echo esc_attr( $thursday ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'friday' ); ?>">
				<?php esc_html_e( 'Friday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'friday' ); ?>"
                   name="<?php echo $this->get_field_name( 'friday' ); ?>"
                   value="<?php echo esc_attr( $friday ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'saturday' ); ?>">
				<?php esc_html_e( 'Saturday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'saturday' ); ?>"
                   name="<?php echo $this->get_field_name( 'saturday' ); ?>"
                   value="<?php echo esc_attr( $saturday ); ?>">

        </p>
        <p>

            <label for="<?php echo $this->get_field_id( 'sunday' ); ?>">
				<?php esc_html_e( 'Sunday', 'linguini' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo $this->get_field_id( 'sunday' ); ?>"
                   name="<?php echo $this->get_field_name( 'sunday' ); ?>"
                   value="<?php echo esc_attr( $sunday ); ?>">

        </p>

		<?php

	}

}