<?php

/*

Event Categories Widget

*/

class fy_Widget_Categories_Event extends WP_Widget {

	public function __construct() {

		$widget_options = array(
			'classname'          => 'widget_categories',
			'description'        => esc_html__( 'A widget displays the categories of events. Widget only appears if there are categories.', 'linguini' ),
			'customizer_support' => true,
		);

		parent::__construct( 'widget_categories', FORQY_THEME_NAME . ': ' . esc_html__( 'Event Categories', 'linguini' ), $widget_options );

	}

	function widget( $args, $instance ) {

		extract( $args );

		$widget_title = apply_filters( 'widget_title', $instance['widget_title'] );

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_attr( $widget_title ) . $args['after_title'];
		}

		if ( get_terms( array( 'taxonomy' => 'category-event' ) ) ) {
			linguini_categories( 'category-event' );
		}

		echo $args['after_widget'];

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance = $new_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );

		return $instance;

	}

	function form( $instance ) {

		$defaults = array(
			'widget_title' => esc_html__( 'Event Categories', 'linguini' )
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$widget_title = isset( $instance['widget_title'] ) ? esc_html( $instance['widget_title'] ) : '';

		?>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_title' ); ?>">
				<?php esc_html_e( 'Title:', 'linguini' ); ?>
            </label>

            <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'widget_title' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_title' ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">

        </p>

		<?php

	}

}
