<?php

/*

Call to Action Widget

*/

class fy_Widget_Banner extends WP_Widget {

	public function __construct() {

		$widget_options = array(
			'classname'          => 'widget_banner',
			'description'        => esc_html__( 'A widget displays the banner or any call to action.', 'linguini' ),
			'customizer_support' => true,
		);

		parent::__construct( 'widget_banner', FORQY_THEME_NAME . ': ' . esc_html__( 'Banner', 'linguini' ), $widget_options );

	}

	function widget( $args, $instance ) {

		// Vars
		$widget_image   = $instance['widget_image'];
		$widget_title   = apply_filters( 'widget_title', $instance['widget_title'] );
		$widget_content = apply_filters( 'widget_text', $instance['widget_content'] );

		$widget_button      = $instance['widget_button'];
		$widget_button_text = $instance['widget_button_text'];
		$widget_button_link = $instance['widget_button_link'];

		echo $args['before_widget'];

		if ( ! empty( $widget_image ) ) {
			echo '<div class="fy-widget-image js-lazy" data-src="' . esc_url( $widget_image ) . '"></div>';
		}
		if ( ! $widget_button ) {
			$widget_button_class = 'fy-widget-has-no-button';
		} else {
			$widget_button_class = 'fy-widget-has-button';
		}

		echo '<div class="fy-widget-container ' . $widget_button_class . '">';
		echo '<div class="fy-widget-centerer">';

		if ( ! empty( $widget_title ) ) {
			echo $args['before_title'];
			if ( ! empty( $widget_button_link ) ) {
				echo '<a href="' . esc_url( $widget_button_link ) . '">' . esc_html( $widget_title ) . '</a>';
			} else {
				echo esc_attr( $widget_title );
			}
			echo $args['after_title'];
		}

		if ( ! empty( $widget_content ) ) {
			echo '<div class="fy-widget-content">' . do_shortcode( wpautop( $widget_content ) ) . '</div>';
		}

		echo '</div>';
		echo '</div>';

		if ( $widget_button && ! empty( $widget_button_text ) ) {
			echo '<div class="fy-button-container">';
			echo '<a class="fy-button fy-button-bordered fy-button-small" href="' . esc_url( $widget_button_link ) . '">' . esc_html( $widget_button_text ) . '</a>';
			echo '</div>';
		}

		echo $args['after_widget'];

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance = $new_instance;

		$instance['widget_image']       = strip_tags( $new_instance['widget_image'] );
		$instance['widget_title']       = strip_tags( $new_instance['widget_title'] );
		$instance['widget_content']     = $new_instance['widget_content'];
		$instance['widget_button']      = $new_instance['widget_button'];
		$instance['widget_button_text'] = strip_tags( $new_instance['widget_button_text'] );
		$instance['widget_button_link'] = strip_tags( $new_instance['widget_button_link'] );

		return $instance;

	}

	function form( $instance ) {

		$defaults = array(
			'widget_image'       => '',
			'widget_title'       => '',
			'widget_button_text' => esc_html__( 'View more', 'linguini' ),
			'widget_button_link' => ''
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$widget_image       = isset( $instance['widget_image'] ) ? esc_html( $instance['widget_image'] ) : '';
		$widget_title       = isset( $instance['widget_title'] ) ? esc_html( $instance['widget_title'] ) : '';
		$widget_content     = isset( $instance['widget_content'] ) ? esc_html( $instance['widget_content'] ) : '';
		$widget_button      = isset( $instance['widget_button'] ) ? esc_html( $instance['widget_button'] ) : '';
		$widget_button_text = isset( $instance['widget_button_text'] ) ? esc_html( $instance['widget_button_text'] ) : 'View more';
		$widget_button_link = isset( $instance['widget_button_link'] ) ? esc_html( $instance['widget_button_link'] ) : '';

		?>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_title' ); ?>">
				<?php esc_html_e( 'Title:', 'linguini' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_title' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_title' ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">

        </p>

        <p class="fy-media-uploader<?php if ( $instance['widget_image'] != '' ) { ?> uploaded<?php } ?>">

            <label for="<?php echo $this->get_field_id( 'widget_image' ); ?>">
				<?php esc_html_e( 'Image:', 'linguini' ); ?>
            </label>

            <img class="fy-media-image-preview js-media-image-preview"
                 src="<?php echo esc_url( $instance['widget_image'] ); ?>" alt="">

            <input type="hidden"
                   class="widefat js-media-image-input"
                   name="<?php echo $this->get_field_name( 'widget_image' ); ?>"
                   id="<?php echo $this->get_field_id( 'widget_image' ); ?>"
                   value="<?php echo esc_url( $widget_image ); ?>">

            <input type="button"
                   class="button button-primary js-media-button-upload"
                   name="upload_button"
                   value="<?php esc_attr_e( 'Select image', 'linguini' ); ?>">

            <input type="button"
                   class="button button-secondary fy-media-button-remove js-media-button-remove"
                   name="remove_button"
                   value="<?php esc_attr_e( 'Remove image', 'linguini' ); ?>">

        </p>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_content' ); ?>">
				<?php esc_html_e( 'Content:', 'linguini' ); ?>
            </label>

            <textarea class="widefat"
                      rows="12"
                      cols="20"
                      id="<?php echo $this->get_field_id( 'widget_content' ); ?>"
                      name="<?php echo $this->get_field_name( 'widget_content' ); ?>"><?php echo esc_html( $widget_content ); ?></textarea>

        </p>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_button_link' ); ?>">
				<?php esc_html_e( 'URL:', 'linguini' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_button_link' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_button_link' ); ?>"
                   value="<?php echo esc_url( $widget_button_link ); ?>">

        </p>

        <p>

            <input type="checkbox"
                   class="checkbox"
                   id="<?php echo $this->get_field_id( 'widget_button' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_button' ); ?>"<?php if ( $widget_button ) { ?> checked="checked"<?php } ?>>

            <label for="<?php echo $this->get_field_id( 'widget_button' ); ?>">
				<?php esc_html_e( 'Show button?', 'linguini' ); ?>
            </label>

        </p>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_button_text' ); ?>">
				<?php esc_html_e( 'Button text:', 'linguini' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_button_text' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_button_text' ); ?>"
                   value="<?php echo esc_attr( $widget_button_text ); ?>">

        </p>

		<?php

	}

}