<?php

/*

About Widget

*/

class fy_Widget_About extends WP_Widget {

	public function __construct() {

		$widget_options = array(
			'classname'          => 'widget_about',
			'description'        => esc_html__( 'A widget displays information about your restaurant.', 'linguini' ),
			'customizer_support' => true,
		);

		parent::__construct( 'widget_about', FORQY_THEME_NAME . ': ' . esc_html__( 'About', 'linguini' ), $widget_options );

	}

	function widget( $args, $instance ) {

		// Vars
		$widget_title   = apply_filters( 'widget_title', $instance['widget_title'] );
		$widget_content = apply_filters( 'widget_text', $instance['widget_content'] );

		$widget_button_text = $instance['widget_button_text'];
		$widget_button_link = $instance['widget_button_link'];

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		}

		if ( $widget_content ) {
			?>

            <div class="fy-widget-content fy-content">
				<?php echo do_shortcode( wpautop( $widget_content ) ); ?>
            </div>

			<?php
		}

		if ( ! empty( $instance['widget_button'] ) ) {
			?>

            <a href="<?php echo esc_url( $widget_button_link ); ?>" class="fy-button fy-button-bordered fy-button-small">
				<?php echo esc_html( $widget_button_text ); ?>
            </a>

			<?php
		}

		echo $args['after_widget'];

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance = $new_instance;

		$instance['widget_title']       = strip_tags( $new_instance['widget_title'] );
		$instance['widget_content']     = $new_instance['widget_content'];
		$instance['widget_button']      = $new_instance['widget_button'];
		$instance['widget_button_text'] = strip_tags( $new_instance['widget_button_text'] );
		$instance['widget_button_link'] = strip_tags( $new_instance['widget_button_link'] );

		return $instance;

	}

	function form( $instance ) {

		$defaults = array(
			'widget_title'       => esc_html__( 'About us', 'linguini' ),
			'widget_button_text' => esc_html__( 'About us', 'linguini' ),
			'widget_button_link' => ''
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$widget_title       = isset( $instance['widget_title'] ) ? esc_html( $instance['widget_title'] ) : '';
		$widget_content     = isset( $instance['widget_content'] ) ? esc_html( $instance['widget_content'] ) : '';
		$widget_button      = isset( $instance['widget_button'] ) ? esc_html( $instance['widget_button'] ) : '';
		$widget_button_text = isset( $instance['widget_button_text'] ) ? esc_html( $instance['widget_button_text'] ) : '';
		$widget_button_link = isset( $instance['widget_button_link'] ) ? esc_html( $instance['widget_button_link'] ) : '';

		?>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_title' ); ?>">
				<?php esc_html_e( 'Title:', 'linguini' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_title' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_title' ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">

        </p>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_content' ); ?>">
				<?php esc_html_e( 'Content:', 'linguini' ); ?>
            </label>

            <textarea class="widefat"
                      rows="12"
                      cols="20"
                      id="<?php echo $this->get_field_id( 'widget_content' ); ?>"
                      name="<?php echo $this->get_field_name( 'widget_content' ); ?>"><?php echo esc_html( $widget_content ); ?></textarea>

        </p>

        <p>

            <input type="checkbox"
                   class="checkbox"
                   id="<?php echo $this->get_field_id( 'widget_button' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_button' ); ?>"<?php if ( $widget_button ) { ?> checked="checked"<?php } ?>>

            <label for="<?php echo $this->get_field_id( 'widget_button' ); ?>">
				<?php esc_html_e( 'Show button?', 'linguini' ); ?>
            </label>

        </p>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_button_text' ); ?>">
				<?php esc_html_e( 'Button text:', 'linguini' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_button_text' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_button_text' ); ?>"
                   value="<?php echo esc_attr( $widget_button_text ); ?>">

        </p>

        <p>

            <label for="<?php echo $this->get_field_id( 'widget_button_link' ); ?>">
				<?php esc_html_e( 'Button URL:', 'linguini' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo $this->get_field_id( 'widget_button_link' ); ?>"
                   name="<?php echo $this->get_field_name( 'widget_button_link' ); ?>"
                   value="<?php echo esc_url( $widget_button_link ); ?>">

        </p>

		<?php

	}

}