<?php

/*

Styles

*/

if ( ! function_exists( 'linguini_theme_styles' ) ) {

	function linguini_theme_styles() {

		if ( ! is_admin() ) {

			// Theme Stylesheet

			if ( class_exists( 'forqy_less' ) ) {
				wp_enqueue_style( get_template(), trailingslashit( get_template_directory_uri() ) . 'style.less', array(), '', 'all' );
			} else {
				wp_enqueue_style( get_template(), trailingslashit( get_template_directory_uri() ) . 'css/theme.css', array(), '', 'all' );
			}

			// Admin Bar Styles

			if ( is_admin_bar_showing() ) {

				$custom_css = "
                #wpadminbar { z-index: 90 !important; }
                @media (max-width: 600px) {
					#wpadminbar { position: fixed; }
			    }
                ";

				wp_add_inline_style( get_template(), $custom_css );

			}

		}

	}

	add_action( 'wp_enqueue_scripts', 'linguini_theme_styles', 20, 10 );

}


// Body Classes

if ( ! function_exists( 'linguini_theme_body_class' ) ) {

	function linguini_theme_body_class( $classes ) {

		// Loading
		if ( get_theme_mod( 'fy_loading', linguini_default( 'fy_loading' ) ) == 'disabled' ) {
			$classes[] = 'loading-disabled';
		} else {
			$classes[] = 'loading-enabled';
		}

		// Shadows
		if ( get_theme_mod( 'fy_style_shadow' ) == 'disabled' ) {
			$classes[] = 'no-shadow';
		}

		// Content Background == Widgets Background
		if ( get_theme_mod( 'fy_content_color_background' ) == get_theme_mod( 'fy_footer_widgets_color_background' ) ) {
			$classes[] = 'content-widgets-merge';
		}

		// Content Background == Footer Background
		if ( get_theme_mod( 'fy_content_color_background' ) == get_theme_mod( 'fy_footer_color_background' ) ) {
			$classes[] = 'content-footer-merge';
		}

		// Footer Background == Widgets Background
		if ( get_theme_mod( 'fy_footer_color_background' ) == get_theme_mod( 'fy_footer_widgets_color_background' ) ) {
			$classes[] = 'footer-widgets-merge';
		}

		return $classes;
	}

	add_filter( 'body_class', 'linguini_theme_body_class' );

}
