<?php

/*

Theme Less Functions

*/

if ( class_exists( 'forqy_less' ) ) {

	if ( ! function_exists( 'linguini_theme_variables' ) ) {

		function linguini_theme_variables( $vars ) {

			// Background
			$vars['background-color']           = get_theme_mod( 'fy_background_color', linguini_default( 'fy_background_color' ) );
			$vars['background-overlay-color']   = get_theme_mod( 'fy_background_overlay_color', linguini_default( 'fy_background_overlay_color' ) );
			$vars['background-overlay-opacity'] = get_theme_mod( 'fy_background_overlay_opacity', linguini_default( 'fy_background_overlay_opacity' ) ) . '%';

			// Header
			$vars['header-color']            = get_theme_mod( 'fy_header_color', linguini_default( 'fy_header_color' ) );
			$vars['header-color-accent']     = get_theme_mod( 'fy_header_color_accent', linguini_default( 'fy_header_color_accent' ) );
			$vars['header-color-background'] = get_theme_mod( 'fy_header_color_background', linguini_default( 'fy_header_color_background' ) );

			$vars['header-overlay-color']   = get_theme_mod( 'fy_header_overlay_color', linguini_default( 'fy_header_overlay_color' ) );
			$vars['header-overlay-opacity'] = get_theme_mod( 'fy_header_overlay_opacity', linguini_default( 'fy_header_overlay_opacity' ) ) . '%';

			// Navigation
			$vars['navigation-color']            = get_theme_mod( 'fy_navigation_color', linguini_default( 'fy_navigation_color' ) );
			$vars['navigation-color-accent']     = get_theme_mod( 'fy_navigation_color_accent', linguini_default( 'fy_navigation_color_accent' ) );
			$vars['navigation-color-background'] = get_theme_mod( 'fy_navigation_color_background', linguini_default( 'fy_navigation_color_background' ) );

			$vars['navigation-sticky-color']            = get_theme_mod( 'fy_navigation_sticky_color', linguini_default( 'fy_navigation_sticky_color' ) );
			$vars['navigation-sticky-color-accent']     = get_theme_mod( 'fy_navigation_sticky_color_accent', linguini_default( 'fy_navigation_sticky_color_accent' ) );
			$vars['navigation-sticky-color-background'] = get_theme_mod( 'fy_navigation_sticky_color_background', linguini_default( 'fy_navigation_sticky_color_background' ) );

			$vars['navigation-sub-color']            = get_theme_mod( 'fy_navigation_sub_color', linguini_default( 'fy_navigation_sub_color' ) );
			$vars['navigation-sub-color-accent']     = get_theme_mod( 'fy_navigation_sub_color_accent', linguini_default( 'fy_navigation_sub_color_accent' ) );
			$vars['navigation-sub-color-background'] = get_theme_mod( 'fy_navigation_sub_color_background', linguini_default( 'fy_navigation_sub_color_background' ) );

			// Slideshow
			$vars['slideshow-color']            = get_theme_mod( 'fy_slideshow_color', linguini_default( 'fy_slideshow_color' ) );
			$vars['slideshow-color-accent']     = get_theme_mod( 'fy_slideshow_color_accent', linguini_default( 'fy_slideshow_color_accent' ) );
			$vars['slideshow-color-background'] = get_theme_mod( 'fy_slideshow_color_background', linguini_default( 'fy_slideshow_color_background' ) );

			$vars['slideshow-overlay-color']   = get_theme_mod( 'fy_slideshow_overlay_color', linguini_default( 'fy_slideshow_overlay_color' ) );
			$vars['slideshow-overlay-opacity'] = get_theme_mod( 'fy_slideshow_overlay_opacity', linguini_default( 'fy_slideshow_overlay_opacity' ) ) . '%';

			// Badge
			$vars['badge-color']            = get_theme_mod( 'fy_badge_color', linguini_default( 'fy_badge_color' ) );
			$vars['badge-color-accent']     = get_theme_mod( 'fy_badge_color_accent', linguini_default( 'fy_badge_color_accent' ) );
			$vars['badge-color-background'] = get_theme_mod( 'fy_badge_color_background', linguini_default( 'fy_badge_color_background' ) );

			// Heading
			$vars['heading-color']            = get_theme_mod( 'fy_heading_color', linguini_default( 'fy_heading_color' ) );
			$vars['heading-color-accent']     = get_theme_mod( 'fy_heading_color_accent', linguini_default( 'fy_heading_color_accent' ) );
			$vars['heading-color-background'] = get_theme_mod( 'fy_heading_color_background', linguini_default( 'fy_heading_color_background' ) );

			// About
			$vars['about-color']            = get_theme_mod( 'fy_about_color', linguini_default( 'fy_about_color' ) );
			$vars['about-color-accent']     = get_theme_mod( 'fy_about_color_accent', linguini_default( 'fy_about_color_accent' ) );
			$vars['about-color-background'] = get_theme_mod( 'fy_about_color_background', linguini_default( 'fy_about_color_background' ) );

			// Content
			$vars['content-color']            = get_theme_mod( 'fy_content_color', linguini_default( 'fy_content_color' ) );
			$vars['content-color-opacity'] = get_theme_mod( 'fy_content_color_opacity', linguini_default( 'fy_content_color_opacity' ) ) . '%';
			$vars['content-color-accent']     = get_theme_mod( 'fy_content_color_accent', linguini_default( 'fy_content_color_accent' ) );
			$vars['content-color-background'] = get_theme_mod( 'fy_content_color_background', linguini_default( 'fy_content_color_background' ) );

			// Footer
			$vars['footer-color']            = get_theme_mod( 'fy_footer_color', linguini_default( 'fy_footer_color' ) );
			$vars['footer-color-accent']     = get_theme_mod( 'fy_footer_color_accent', linguini_default( 'fy_footer_color_accent' ) );
			$vars['footer-color-background'] = get_theme_mod( 'fy_footer_color_background', linguini_default( 'fy_footer_color_background' ) );

			$vars['footer-widgets-color']            = get_theme_mod( 'fy_footer_widgets_color', linguini_default( 'fy_footer_widgets_color' ) );
			$vars['footer-widgets-color-accent']     = get_theme_mod( 'fy_footer_widgets_color_accent', linguini_default( 'fy_footer_widgets_color_accent' ) );
			$vars['footer-widgets-color-background'] = get_theme_mod( 'fy_footer_widgets_color_background', linguini_default( 'fy_footer_widgets_color_background' ) );

			// Lightbox
			$vars['lightbox-color']            = get_theme_mod( 'fy_lightbox_color', linguini_default( 'fy_lightbox_color' ) );
			$vars['lightbox-color-background'] = get_theme_mod( 'fy_lightbox_color_background', linguini_default( 'fy_lightbox_color_background' ) );

			// States
			$vars['error-color']   = get_theme_mod( 'fy_error_color', linguini_default( 'fy_error_color' ) );
			$vars['success-color'] = get_theme_mod( 'fy_success_color', linguini_default( 'fy_success_color' ) );

			// Overlay
			$vars['overlay-color']   = get_theme_mod( 'fy_overlay_color', linguini_default( 'fy_overlay_color' ) );
			$vars['overlay-opacity'] = get_theme_mod( 'fy_overlay_opacity', linguini_default( 'fy_overlay_opacity' ) ) . '%';

			// Fonts
			$vars['font-primary']   = '"' . get_theme_mod( 'fy_font_primary', linguini_default( 'fy_font_primary' ) ) . '", "Arial", "Helvetica", sans-serif';
			$vars['font-secondary'] = '"' . get_theme_mod( 'fy_font_secondary', linguini_default( 'fy_font_secondary' ) ) . '", "Arial", "Helvetica", sans-serif';
			$vars['font-size']      = get_theme_mod( 'fy_font_size', linguini_default( 'fy_font_size' ) );
			$vars['letter-spacing'] = get_theme_mod( 'fy_letter_spacing', linguini_default( 'fy_letter_spacing' ) );
			$vars['text-transform'] = get_theme_mod( 'fy_text_transform', linguini_default( 'fy_text_transform' ) );

			return $vars;

		}

		add_filter( 'less_vars', 'linguini_theme_variables', 10, 2 );

	}

}

// Global Variables

if ( ! function_exists( 'linguini_theme_variables_global' ) ) {

	function linguini_theme_variables_global( $vars ) {

		// Theme URL

		$vars['template_directory_uri']   = '~"' . get_template_directory_uri() . '"';
		$vars['stylesheet_directory_uri'] = '~"' . get_stylesheet_directory_uri() . '"';

		return $vars;

	}

	add_filter( 'less_vars', 'linguini_theme_variables_global', 10, 2 );

}