<?php

/*

Default Values

*/

/*
====================================================================================================
Set Defaults
====================================================================================================
*/

if ( ! function_exists( 'linguini_theme_defaults' ) ) {

	function linguini_theme_defaults( $default ) {

		$default['fy_loading'] = 'enabled'; // enabled | disabled

		// Background
		$default['fy_background_color']           = '#3c3232';
		$default['fy_background_overlay_color']   = '#3c3232';
		$default['fy_background_overlay_opacity'] = '80';

		// Header
		$default['fy_header_color']            = '#ffffff';
		$default['fy_header_color_accent']     = '#c8504b';
		$default['fy_header_color_background'] = '#463c3c';

		$default['fy_header_overlay_color']   = '#463c3c';
		$default['fy_header_overlay_opacity'] = '80';

		// Navigation
		$default['fy_navigation_color']            = '#c8504b';
		$default['fy_navigation_color_accent']     = '#ffffff';
		$default['fy_navigation_color_background'] = '#3c3232';

		$default['fy_navigation_sticky']                  = 'enabled'; // enabled || disabled
		$default['fy_navigation_sticky_color']            = '#c8504b';
		$default['fy_navigation_sticky_color_accent']     = '#ffffff';
		$default['fy_navigation_sticky_color_background'] = '#3c3232';

		$default['fy_navigation_sub_color']            = '#554b4b';
		$default['fy_navigation_sub_color_accent']     = '#c8504b';
		$default['fy_navigation_sub_color_background'] = '#ffffff';

		// Slideshow
		$default['fy_slideshow_color']            = '#ffffff';
		$default['fy_slideshow_color_accent']     = '#c8504b';
		$default['fy_slideshow_color_background'] = '#3c3232';

		$default['fy_slideshow_overlay_color']   = '#554b4b';
		$default['fy_slideshow_overlay_opacity'] = '50';

		$default['fy_slideshow_direction'] = 'horizontal';
		$default['fy_slideshow_effect']    = 'slide';
		$default['fy_slideshow_loop']      = 'true';
		$default['fy_slideshow_speed']     = '500';
		$default['fy_slideshow_autoplay']  = '10000';

		// Badge

		$default['fy_badge_color']            = '#ffffff';
		$default['fy_badge_color_accent']     = '#ffffff';
		$default['fy_badge_color_background'] = '#c8504b';

		// Heading
		$default['fy_heading_color']            = '#ffffff';
		$default['fy_heading_color_accent']     = '#c8504b';
		$default['fy_heading_color_background'] = '#463c3c';

		// About
		$default['fy_about_color']            = '#ffffff';
		$default['fy_about_color_accent']     = '#c8504b';
		$default['fy_about_color_background'] = '#3c3232';

		// Content
		$default['fy_content_color']            = '#ffffff';
		$default['fy_content_color_opacity']    = '60'; // %
		$default['fy_content_color_accent']     = '#c8504b';
		$default['fy_content_color_background'] = '#3c3232';

		// Footer
		$default['fy_footer_color']            = '#ffffff';
		$default['fy_footer_color_accent']     = '#c8504b';
		$default['fy_footer_color_background'] = '#3c3232';

		$default['fy_footer_widgets_color']            = '#ffffff';
		$default['fy_footer_widgets_color_accent']     = '#c8504b';
		$default['fy_footer_widgets_color_background'] = '#463c3c';

		// Lightbox
		$default['fy_lightbox_color']                    = '#ffffff';
		$default['fy_lightbox_color_background']         = '#3c3232';
		$default['fy_lightbox_color_background_opacity'] = '90';

		// States
		$default['fy_error_color']   = '#c84650';
		$default['fy_success_color'] = '#3cb478';

		// Overlay
		$default['fy_overlay_color']   = '#554b4b';
		$default['fy_overlay_opacity'] = '20';

		// Fonts

		$default['fy_font_primary']        = 'Archivo Narrow';
		$default['fy_font_primary_styles'] = '400,700';

		$default['fy_font_secondary']        = 'Source Sans Pro';
		$default['fy_font_secondary_styles'] = '400,700';

		$default['fy_font_size']      = '16px';
		$default['fy_letter_spacing'] = '0px';
		$default['fy_text_transform'] = 'none';

		// Event date
		$default['fy_event_date_format']    = 'd m Y';
		$default['fy_event_date_delimiter'] = '/';

		// Homepage
		$default['fy_homepage_posts_count']  = '3';
		$default['fy_homepage_events_count'] = '3';

		// Restaurant
		$default['fy_restaurant_reservations'] = 'Yes';
		$default['fy_restaurant_currency']     = 'USD';

		return $default;

	}

}

/*
====================================================================================================
Get Defaults
====================================================================================================
*/

if ( ! function_exists( 'linguini_default' ) ) {

	function linguini_default( $key ) {

		global $default;

		$defaults = linguini_theme_defaults( $default );
		$value    = $defaults[ $key ];

		return $value;

	}

}