<?php

/*

Sidebars

*/

if ( function_exists( 'register_sidebar' ) ) {

	// Blog - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Blog - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on blog pages. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'blog',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Page - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Page - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on pages. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'page',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Homepage - Call to Action

	register_sidebar(
		array(
			'name'          => esc_html__( 'Homepage - Call to Action', 'linguini' ),
			'id'            => 'homepage-call-to-action',
			'before_widget' => '<div class="fy-widget-column fy-flex-column-33 fy-flex-column-tablet-50 fy-flex-column-phone-100"><div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Homepage

	register_sidebar(
		array(
			'name'          => esc_html__( 'Homepage', 'linguini' ),
			'id'            => 'homepage',
			'before_widget' => '<div class="fy-widget-column fy-flex-column-auto fy-flex-column-tablet-50 fy-flex-column-phone-100"><div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Menu - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Menu - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on menu pages. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'menu',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Event - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Events - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on event pages. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'event',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Gallery - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Galleries - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on gallery pages. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'gallery',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Reservations - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Reservations - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on reservation page. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'reservation',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Contact - Sidebar

	register_sidebar(
		array(
			'name'          => esc_html__( 'Contact - Sidebar', 'linguini' ),
			'description'   => esc_html__( 'The sidebar is appearing on contact page. Sidebar won\'t be displayed when won\'t be placed a widget.', 'linguini' ),
			'id'            => 'contact',
			'before_widget' => '<div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="fy-widget-title">',
			'after_title'   => '</h3>'
		)
	);

	// Footer

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer', 'linguini' ),
			'description'   => esc_html__( 'Footer widget area.', 'linguini' ),
			'id'            => 'footer',
			'before_widget' => '<div class="fy-widget-column fy-flex-column-auto fy-flex-column-tablet-50 fy-flex-column-phone-100"><div id="%1$s" class="fy-widget widget %2$s">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3 class="fy-widget-title"><span>',
			'after_title'   => '</span></h3>'
		)
	);

}
