<?php

/*

Setup

*/

// Define Theme

define( 'FORQY_THEME_NAME', 'Linguini' );
define( 'FORQY_THEME_SLUG', 'linguini' );

// Setup Theme

if ( ! function_exists( 'linguini_theme_setup' ) ) {

	function linguini_theme_setup() {

		// Add Post Formats Support
		add_theme_support( 'post-formats', array(
			'audio',
			'gallery',
			'video'
		) );

		// Add Semantic Markup Support
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script'
		) );

		// Add Custom Header Support
		add_theme_support( 'custom-header', array(
			'default-image'      => '',
			'width'              => '1920',
			'height'             => '1280',
			'flex-width'         => true,
			'flex-height'        => true,
			'uploads'            => true,
			'random-default'     => false,
			'header-text'        => false,
			'default-text-color' => '',
		) );

		// Add Custom Background Support
		add_theme_support( 'custom-background', array(
			'default-image'      => '',
			'default-preset'     => 'default',
			'default-position-x' => 'center',
			'default-position-y' => 'center',
			'default-size'       => 'auto',
			'default-repeat'     => 'no-repeat',
			'default-attachment' => 'scroll',
			'default-color'      => '',
		) );

		// Add Align Wide Support
		add_theme_support( 'align-wide' );

		// Add Block Styles Support
		add_theme_support( 'wp-block-styles' );

		// Add Responsive Embeds Support
		add_theme_support( 'responsive-embeds' );

		// Add Title Tag Support
		add_theme_support( 'title-tag' );

		// Add Post Thumbnails Support
		add_theme_support( 'post-thumbnails' );

		// Add Automatic Feed Links Support
		add_theme_support( 'automatic-feed-links' );

		// Add Widget Customizer Support
		add_theme_support( 'widget-customizer' );

		// Add Customize Selective Refresh Support
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add Editor Styles Support
		add_theme_support( 'editor-styles' );

		// Add Editor Colors Support
		add_theme_support( 'editor-color-palette', array(
			array(
				'name'  => __( 'Color', 'linguini' ),
				'slug'  => 'cnt',
				'color' => get_theme_mod( 'fy_content_color', linguini_default( 'fy_content_color' ) ),
			),
			array(
				'name'  => __( 'Color Accent', 'linguini' ),
				'slug'  => 'cnt-ac',
				'color' => get_theme_mod( 'fy_content_color_accent', linguini_default( 'fy_content_color_accent' ) ),
			),
			array(
				'name'  => __( 'Color Background', 'linguini' ),
				'slug'  => 'cnt-bg',
				'color' => get_theme_mod( 'fy_content_color_background', linguini_default( 'fy_content_color_background' ) ),
			),
		) );

		// Add Editor Style
		add_editor_style( 'css/editor.css' );

		// Add Translation Support
		load_theme_textdomain( FORQY_THEME_SLUG, trailingslashit( get_template_directory() ) . 'languages' );

		// Set Post Thumbnail Size
		set_post_thumbnail_size( 300, 300, array(
			'center',
			'center'
		) );

		// FORQY

		// Taximage Support
		add_theme_support( 'forqy-taximage' );
		// Shortcodes Support
		add_theme_support( 'forqy-shortcodes' );
		// Socials Support
		add_theme_support( 'forqy-socials' );
		// Event Support
		add_theme_support( 'forqy-event' );

	}

	add_action( 'after_setup_theme', 'linguini_theme_setup' );

}