<?php

/*

Swiper Scripts

*/

if ( ! function_exists( 'linguini_theme_swiper_scripts' ) ) {

	function linguini_theme_swiper_scripts() {

		// Variables
		$slideshow_direction = get_theme_mod( 'fy_slideshow_direction', linguini_default( 'fy_slideshow_direction' ) );
		$slideshow_effect    = get_theme_mod( 'fy_slideshow_effect', linguini_default( 'fy_slideshow_effect' ) );
		$slideshow_speed     = get_theme_mod( 'fy_slideshow_speed', linguini_default( 'fy_slideshow_speed' ) );
		$slideshow_loop      = get_theme_mod( 'fy_slideshow_loop', linguini_default( 'fy_slideshow_loop' ) );
		$slideshow_autoplay  = get_theme_mod( 'fy_slideshow_autoplay', linguini_default( 'fy_slideshow_autoplay' ) );

		// Script
		$swiper = "
            const slideshow = new Swiper('.js-slideshow', {
                effect: '" . esc_js( $slideshow_effect ) . "',
                loop: " . esc_js( $slideshow_loop ) . ",
                speed: " . esc_js( $slideshow_speed ) . ",
                direction: '" . esc_js( $slideshow_direction ) . "',
                threshold: 5,
                grabCursor: true,
                keyboard: true,

                // Lazy loading
                preloadImages: false,
                lazy: {
                    loadPrevNext: true
                },

                // Navigation
                navigation: {
                    prevEl: '.js-slideshow-prev',
                    nextEl: '.js-slideshow-next'
                },

                // Accessibility
                a11y: {
                    prevSlideMessage: '" . esc_html__( 'Previous', 'linguini' ) . "',
                    nextSlideMessage: '" . esc_html__( 'Next', 'linguini' ) . "'
                },

				// On
                on: {
                
                    // Loaded Image
	                lazyImageReady: function () {
	                
	                    // Autoplay
	                    if (!this.autoplay.running) {
	                        this.params.autoplay = {
	                            delay: " . esc_js( $slideshow_autoplay ) . ",
	                            stopOnLast: true,
	                            disableOnInteraction: true
	                        };
	                        this.autoplay.start();
	                    }
	                }
	            }

            });
        ";

		wp_add_inline_script( 'swiper', $swiper );

	}

	add_action( 'wp_enqueue_scripts', 'linguini_theme_swiper_scripts', 30 );

}
