<?php

/*

Scripts

*/

/*
====================================================================================================
Theme Scripts
====================================================================================================
*/

if ( ! function_exists( 'linguini_theme_scripts' ) ) {

	function linguini_theme_scripts() {

		if ( ! is_admin() ) {

			/**
			 * Components
			 */

			/**
			 * Pace
			 * @url https://github.com/HubSpot/pace
			 * @source https://github.com/HubSpot/pace/blob/master/pace.js
			 */
			wp_enqueue_script( 'pace', trailingslashit( get_template_directory_uri() ) . 'js/components/pace.js', array(), '1.0.2', true );

			/**
			 * jQuery Lazy
			 * @url https://github.com/dkern/jquery.lazy
			 * @source https://github.com/dkern/jquery.lazy/blob/master/jquery.lazy.js
			 */
			wp_enqueue_script( 'jquery-lazy', trailingslashit( get_template_directory_uri() ) . 'js/components/jquery.lazy.js', array(
				'jquery'
			), '1.7.10', true );

			/**
			 * Swiper
			 * @url https://github.com/nolimits4web/swiper
			 * @source Custom Build
			 */
			wp_enqueue_script( 'swiper', trailingslashit( get_template_directory_uri() ) . 'js/components/swiper.js', array(
				'jquery'
			), '6.0.4', true );

			/**
			 * PhotoSwipe
			 * @url https://github.com/dimsemenov/PhotoSwipe
			 * @source https://github.com/dimsemenov/PhotoSwipe/blob/master/dist/photoswipe.js
			 * @source https://github.com/dimsemenov/PhotoSwipe/blob/master/dist/photoswipe-ui-default.js
			 */
			wp_enqueue_script( 'photoswipe', trailingslashit( get_template_directory_uri() ) . 'js/components/photoswipe.js', array(
				'jquery'
			), '4.1.3', true );
			wp_enqueue_script( 'photoswipe-ui-default', trailingslashit( get_template_directory_uri() ) . 'js/components/photoswipe-ui-default.js', array(
				'jquery',
				'photoswipe'
			), '4.1.3', true );

			/**
			 * Double Tap to Go
			 * @url https://github.com/dachcom-digital/jquery-doubletaptogo
			 * @source https://github.com/dachcom-digital/jquery-doubletaptogo/blob/master/dist/jquery.dcd.doubletaptogo.js
			 */
			wp_enqueue_script( 'double-tap-to-go', trailingslashit( get_template_directory_uri() ) . 'js/components/doubletaptogo.js', array(
				'jquery'
			), '3.0.2', true );

			/**
			 * Theme
			 */

			// Theme
			wp_enqueue_script( get_template(), trailingslashit( get_template_directory_uri() ) . 'js/theme.js', array(
				'jquery',
				'pace'
			), '1.0.1', true );

			// Sticky
			wp_enqueue_script( get_template() . '-sticky', trailingslashit( get_template_directory_uri() ) . 'js/sticky.js', array(
				'jquery',
			), '1.0.1', true );

			// Navigation
			wp_enqueue_script( get_template() . '-navigation', trailingslashit( get_template_directory_uri() ) . 'js/navigation.js', array(
				'jquery',
				'double-tap-to-go'
			), '1.0.1', true );

			/**
			 * Core
			 */

			// Lazy
			wp_enqueue_script( get_template() . '-lazy', trailingslashit( get_template_directory_uri() ) . 'vendor/forqy/core/js/lazy.js', array(
				'jquery',
				'jquery-lazy'
			), '1.0.1', true );

			// Images
			wp_enqueue_script( get_template() . '-images', trailingslashit( get_template_directory_uri() ) . 'vendor/forqy/core/js/images.js', array(
				'jquery',
				'photoswipe',
				'photoswipe-ui-default'
			), '1.0.1', true );

			// Back to Top
			wp_enqueue_script( get_template() . '-back-to-top', trailingslashit( get_template_directory_uri() ) . 'vendor/forqy/core/js/back-to-top.js', array(
				'jquery',
			), '1.0.1', true );

			// Links
			wp_enqueue_script( get_template() . '-links', trailingslashit( get_template_directory_uri() ) . 'vendor/forqy/core/js/links.js', array(), '1.0.0', true );

		}

		if ( is_singular() && get_option( 'thread_comments' ) && comments_open() ) {
			// Comment Reply
			wp_enqueue_script( 'comment-reply' );
		}

	}

	add_action( 'wp_enqueue_scripts', 'linguini_theme_scripts', 20 );

}

// Remove jQuery Migrate
// https://github.com/cedaro/dequeue-jquery-migrate/blob/develop/dequeue-jquery-migrate.php

if ( ! function_exists( 'linguini_theme_remove_jquery_migrate' ) ) {

	function linguini_theme_remove_jquery_migrate( $scripts ) {

		if ( ! is_admin() && ! empty( $scripts->registered['jquery'] ) ) {
			$jquery_dependencies                 = $scripts->registered['jquery']->deps;
			$scripts->registered['jquery']->deps = array_diff( $jquery_dependencies, array( 'jquery-migrate' ) );
		}

	}

	add_action( 'wp_default_scripts', 'linguini_theme_remove_jquery_migrate' );

}

/*
====================================================================================================
Admin Scripts
====================================================================================================
*/

if ( ! function_exists( 'linguini_admin_scripts' ) ) {

	function linguini_admin_scripts() {

		/**
		 * Widget
		 */

		// Register
		wp_register_script( get_template() . '-widget', trailingslashit( get_template_directory_uri() ) . 'vendor/forqy/core/js/admin/widget.js', array( 'jquery' ) );

		// Localize
		$translation_array = array(
			'select_image'       => esc_html__( 'Select image', 'linguini' ),
			'use_selected_image' => esc_html__( 'Use selected image', 'linguini' )
		);
		wp_localize_script( get_template() . '-widget', 'translation', $translation_array );

		// Enqueue
		wp_enqueue_script( get_template() . '-widget' );

	}

	add_action( 'admin_enqueue_scripts', 'linguini_admin_scripts' );

}
