<?php

/*

Import

*/

/*
====================================================================================================
Import Files
====================================================================================================
*/

if ( ! function_exists( 'linguini_import_demo_files' ) ) {

	function linguini_import_demo_files() {
		return array(
			array(
				'import_file_name'           => 'Linguini Winery',
				'import_file_url'            => esc_url( 'https://linguini.forqy.website/content/winery/content.xml' ),
				'import_customizer_file_url' => esc_url( 'https://linguini.forqy.website/content/winery/settings.dat' ),
				'import_widget_file_url'     => esc_url( 'https://linguini.forqy.website/content/winery/widgets.json' ),
				'import_preview_image_url'   => esc_url( 'https://linguini.forqy.website/content/linguini-winery.jpg' ),
				'preview_url'                => esc_url( 'https://linguini.forqy.website/winery/' ),
			),
			array(
				'import_file_name'           => 'Linguini Restaurant',
				'import_file_url'            => esc_url( 'https://linguini.forqy.website/content/restaurant/content.xml' ),
				'import_customizer_file_url' => esc_url( 'https://linguini.forqy.website/content/restaurant/settings.dat' ),
				'import_widget_file_url'     => esc_url( 'https://linguini.forqy.website/content/restaurant/widgets.json' ),
				'import_preview_image_url'   => esc_url( 'https://linguini.forqy.website/content/linguini-restaurant.jpg' ),
				'preview_url'                => esc_url( 'https://linguini.forqy.website/restaurant/' ),
			),
			array(
				'import_file_name'           => 'Linguini Bistro',
				'import_file_url'            => esc_url( 'https://linguini.forqy.website/content/bistro/content.xml' ),
				'import_customizer_file_url' => esc_url( 'https://linguini.forqy.website/content/bistro/settings.dat' ),
				'import_widget_file_url'     => esc_url( 'https://linguini.forqy.website/content/bistro/widgets.json' ),
				'import_preview_image_url'   => esc_url( 'https://linguini.forqy.website/content/linguini-bistro.jpg' ),
				'preview_url'                => esc_url( 'https://linguini.forqy.website/bistro/' ),
			)
		);
	}

	add_filter( 'pt-ocdi/import_files', 'linguini_import_demo_files' );

}

/*
====================================================================================================
Actions after import
====================================================================================================
*/

if ( ! function_exists( 'linguini_theme_import_files' ) ) {

	function linguini_theme_import_files() {

		// Set navigation
		$main_menu = get_term_by( 'name', 'Primary Menu', 'nav_menu' );

		set_theme_mod( 'nav_menu_locations', array(
				'navigation_primary' => $main_menu->term_id,
				'navigation_footer'  => $main_menu->term_id,
			)
		);

		// Set pages
		$front_page_id = get_page_by_title( 'Home' );
		$blog_page_id  = get_page_by_title( 'Blog' );

		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
		update_option( 'page_for_posts', $blog_page_id->ID );
	}

	add_action( 'pt-ocdi/after_import', 'linguini_theme_import_files' );

}

/*
====================================================================================================
Page Settings
====================================================================================================
*/

if ( ! function_exists( 'linguini_theme_import_page' ) ) {

	function linguini_theme_import_page( $default_settings ) {
		$default_settings['menu_title'] = esc_html__( 'Import Demo', 'linguini' );
		$default_settings['menu_slug']  = 'forqy-import';

		return $default_settings;
	}

	add_filter( 'pt-ocdi/plugin_page_setup', 'linguini_theme_import_page' );

}

if ( ! function_exists( 'linguini_theme_import_page_title' ) ) {

	function linguini_theme_import_page_title() {
		return '<h1>' . esc_html__( 'Import Demo', 'linguini' ) . '</h1>';
	}

	add_filter( 'pt-ocdi/plugin_page_title', 'linguini_theme_import_page_title' );

}

/*
====================================================================================================
Disable PT Branding
====================================================================================================
*/

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
