<?php

/*

Theme RSS Functions

*/

/*
====================================================================================================
Add to RSS
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Add Custom Post Types to RSS
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_rss_add_post_types' ) ) {

	function linguini_rss_add_post_types( $qv ) {

		if ( isset( $qv['feed'] ) && ! isset( $qv['post_type'] ) ) {
			$qv['post_type'] = array( 'post', 'menu', 'event', 'gallery', 'video' );
		}

		return $qv;

	}

	add_filter( 'request', 'linguini_rss_add_post_types' );

}

/*
----------------------------------------------------------------------------------------------------
Add Thumbnails to RSS
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_rss_add_thumbnails' ) ) {

	function linguini_rss_add_thumbnails( $content ) {
		global $post;

		if ( has_post_thumbnail( $post->ID ) ) {
			$content = '<p>' . get_the_post_thumbnail( $post->ID, 'medium' ) . '</p>' . get_the_content();
		}

		return $content;

	}

	add_filter( 'the_excerpt_rss', 'linguini_rss_add_thumbnails' );
	add_filter( 'the_content_feed', 'linguini_rss_add_thumbnails' );

}
