<?php

/*

Theme Posts Functions

*/

// Excerpt Length

if ( ! function_exists( 'linguini_excerpt_length' ) ) {

	function linguini_excerpt_length() {
		return 36;
	}

	add_filter( 'excerpt_length', 'linguini_excerpt_length', 999 );

}

// Excerpt More

if ( ! function_exists( 'linguini_excerpt_more' ) ) {

	function linguini_excerpt_more() {
		return ' ...';
	}

	add_filter( 'excerpt_more', 'linguini_excerpt_more', 999 );

}

// Post Meta

if ( ! function_exists( 'linguini_post_meta' ) ) {

	function linguini_post_meta() {
		?>

        <ul class="fy-post-meta">
            <li class="fy-post-meta-date">
                <a href="<?php the_permalink(); ?>">
					<?php the_time( get_option( 'date_format' ) ); ?>
                </a>
            </li>
        </ul>

		<?php
	}

}

// Post Taxonomies

if ( ! function_exists( 'linguini_post_terms' ) ) {

	function linguini_post_terms() {
		global $post;

		if ( has_term( '', 'category-event' ) ) { ?>
            <div class="fy-post-taxonomies">
				<?php linguini_terms_post( $post->ID, 'category-event' ); ?>
            </div>
		<?php }

		if ( has_term( '', 'category-gallery' ) ) { ?>
            <div class="fy-post-taxonomies">
				<?php linguini_terms_post( $post->ID, 'category-gallery' ); ?>
            </div>
		<?php }

		if ( has_category() ) { ?>
            <div class="fy-post-taxonomies">
				<?php
				$categories = get_the_category();
				$separator  = ', ';
				$output     = '';

				if ( $categories ) {
					$output .= '<ul class="fy-terms">';
					foreach ( $categories as $category ) {
						$output .= '<li class="fy-term-item">';
						$output .= '<a href="' . get_category_link( $category->term_id ) . '" title="' . sprintf( esc_html__( 'View all posts in %s', 'linguini' ), $category->name ) . '">' . esc_html( $category->cat_name ) . '</a>';
						$output .= '</li>';
					}
					$output .= '</ul>';
					echo trim( $output, $separator );
				}
				?>
            </div>
		<?php }

		if ( has_tag() ) { ?>
            <div class="fy-post-taxonomies">
                <h3><?php esc_html_e( 'Tags', 'linguini' ); ?></h3>
				<?php the_tags( '<ul class="fy-terms"><li class="fy-term-item">', '</li><li class="fy-term-item">', '</li></ul>' ); ?>
            </div>
			<?php
		}

	}

}

// Event Location

if ( ! function_exists( 'linguini_event_location' ) ) {

	function linguini_event_location( $args = '' ) {
		$defaults = wp_parse_args( $args, array(
			'heading' => true,
			'title'   => true,
			'address' => true
		) );
		?>

        <div class="fy-post-location">
			<?php if ( forqy_meta( 'fy_event_location' ) ) {
				if ( $defaults['title'] != false ) {
					if ( $defaults['heading'] === true ) { ?>
                        <h3 class="fy-post-location-title">
							<?php echo esc_html( forqy_meta( 'fy_event_location' ) ); ?>
                        </h3>
					<?php } else { ?>
                        <div class="fy-post-location-title">
							<?php echo esc_html( forqy_meta( 'fy_event_location' ) ); ?>
                        </div>
					<?php }
				}
			}

			if ( forqy_meta( 'fy_event_location_street' ) || forqy_meta( 'fy_event_location_city' ) || forqy_meta( 'fy_event_location_state' ) ) {
				if ( $defaults['address'] != false ) {
					?>

                    <ul class="fy-event-meta fy-post-meta">
						<?php if ( forqy_meta( 'fy_event_location_street' ) ) { ?>
                            <li class="fy-post-location-street">
								<?php echo esc_html( forqy_meta( 'fy_event_location_street' ) ); ?>
                            </li>
						<?php }

						if ( forqy_meta( 'fy_event_location_city' ) ) { ?>
                            <li class="fy-post-location-city">
								<?php echo esc_html( forqy_meta( 'fy_event_location_city' ) ); ?>
                            </li>
						<?php }

						if ( forqy_meta( 'fy_event_location_state' ) ) { ?>
                            <li class="fy-post-location-state">
								<?php echo esc_html( forqy_meta( 'fy_event_location_state' ) ); ?>
                            </li>
						<?php } ?>
                    </ul>

					<?php
				}
			} ?>

        </div>

		<?php
	}

}

// Event Tickets

if ( ! function_exists( 'linguini_event_tickets' ) ) {

	function linguini_event_tickets() {
		?>

        <div class="fy-post-tickets">

			<?php if ( forqy_meta( 'fy_event_status' ) ) { ?>
                <div class="fy-tickets-status">
					<?php echo esc_html( forqy_meta( 'fy_event_status' ) ); ?>
                </div>
			<?php }

			if ( forqy_meta( 'fy_event_price' ) ) { ?>
                <div class="fy-tickets-price">
					<?php echo esc_html( forqy_meta( 'fy_event_price' ) ); ?>
                </div>
			<?php }

			if ( forqy_meta( 'fy_event_button' ) && forqy_meta( 'fy_event_button_url' ) ) { ?>
                <div class="fy-post-button">
                    <a href="<?php echo esc_url( forqy_meta( 'fy_event_button_url' ) ); ?>" class="fy-button fy-button-bordered">
						<?php echo esc_html( forqy_meta( 'fy_event_button' ) ); ?>
                    </a>
                </div>
			<?php } ?>
        </div>

		<?php
	}

}
