<?php

/*

Theme Pagination Functions

*/

/*
====================================================================================================
Pagination
====================================================================================================
*/

if ( ! function_exists( 'linguini_pagination' ) ) {

	function linguini_pagination( $pages = '', $page_range = '', $paged = '' ) {
		global $paged;

		if ( empty( $page_range ) ) {
			$page_range = 2;
		}

		if ( empty( $paged ) ) {
			$paged = 1;
		}

		if ( $pages == '' ) {
			global $wp_query;

			$pages = $wp_query->max_num_pages;

			if ( ! $pages ) {
				$pages = 1;
			}
		}

		$pagination = paginate_links( array(
			'base'         => get_pagenum_link( 1 ) . '%_%',
			'format'       => '/page/%#%',
			'total'        => $pages,
			'current'      => $paged,
			'show_all'     => false,
			'end_size'     => 1,
			'mid_size'     => $page_range,
			'prev_next'    => true,
			'prev_text'    => '<div>' . esc_html__( '&lsaquo; Previous', 'linguini' ) . '</div>',
			'next_text'    => '<div>' . esc_html__( 'Next &rsaquo;', 'linguini' ) . '</div>',
			'type'         => 'plain',
			'add_args'     => false,
			'add_fragment' => ''
		) );

		if ( $pagination ) { ?>

            <nav class="fy-pagination">
				<?php echo $pagination; ?>
            </nav>

		<?php }

	}

}

/*
====================================================================================================
Paginate Links
====================================================================================================
*/

if ( ! function_exists( 'linguini_paginate_links' ) ) {

	function linguini_paginate_links() {
		global $wp_query;

		$big = 999999999;

		$paginate_links = paginate_links( array(
			'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format'    => '?paged=%#%',
			'current'   => max( 1, get_query_var( 'paged' ) ),
			'total'     => $wp_query->max_num_pages,
			'prev_text' => esc_html__( '&lsaquo; Previous', 'linguini' ),
			'next_text' => esc_html__( 'Next &rsaquo;', 'linguini' ),
			'end_size'  => 1,
			'mid_size'  => 1,
		) );

		if ( $paginate_links ) { ?>

            <nav class="fy-pagination">
				<?php echo $paginate_links; ?>
            </nav>

		<?php }

	}

}

/*
====================================================================================================
Pagination for Posts
====================================================================================================
*/

if ( ! function_exists( 'linguini_pagination_post' ) ) {

	function linguini_pagination_post( $defaults ) {

		return wp_parse_args( array(
			'before' => '<div class="fy-pagination-post" role="navigation" itemscope itemtype="https://schema.org/SiteNavigationElement">',
			'after'  => '</div>',
		), $defaults );

	}

	add_filter( 'wp_link_pages_args', 'linguini_pagination_post' );

}
