<?php

/*

Theme Navigations Functions

*/

/*
====================================================================================================
Register Navigation
====================================================================================================
*/

if ( ! function_exists( 'linguini_theme_register_nav_menus' ) ) {

	function linguini_theme_register_nav_menus() {

		register_nav_menus( array(
			'navigation_primary' => esc_html__( 'Primary navigation', 'linguini' ),
			'navigation_footer'  => esc_html__( 'Footer navigation', 'linguini' )
		) );

	}

	add_action( 'init', 'linguini_theme_register_nav_menus' );

}

/*
====================================================================================================
Get Primary Navigation
====================================================================================================
*/

if ( ! function_exists( 'linguini_navigation' ) ) {

	function linguini_navigation() {

		wp_nav_menu( array(
			'theme_location'  => 'navigation_primary',
			'menu'            => '',
			'container'       => false,
			'menu_class'      => 'fy-navigation-list',
			'menu_id'         => 'navigation_primary',
			'echo'            => true,
			'fallback_cb'     => 'wp_page_menu',
			'before'          => '',
			'after'           => '',
			'link_before'     => '',
			'link_after'      => '',
			'depth'           => 3,
			'walker'          => ''
		) );

	}

}

/*
====================================================================================================
Get Footer Navigation
====================================================================================================
*/

if ( ! function_exists( 'linguini_navigation_footer' ) ) {

	function linguini_navigation_footer() {

		wp_nav_menu( array(
			'theme_location'  => 'navigation_footer',
			'menu'            => '',
			'container'       => 'nav',
			'container_class' => 'fy-navigation-footer',
			'container_id'    => 'navigation-footer',
			'menu_class'      => 'fy-navigation-footer',
			'menu_id'         => 'navigation_footer',
			'echo'            => true,
			'fallback_cb'     => 'wp_page_menu',
			'before'          => '',
			'after'           => '',
			'link_before'     => '',
			'link_after'      => '',
			'depth'           => 1,
			'walker'          => ''
		) );

	}

}

/*
====================================================================================================
Get Categories
====================================================================================================
*/

if ( ! function_exists( 'linguini_categories' ) ) {

	function linguini_categories( $taxonomy = 'category' ) {

		if ( get_terms( array( 'taxonomy' => $taxonomy ) ) ) {
			?>

            <nav class="fy-navigation-categories fy-categories-<?php echo esc_attr( $taxonomy ); ?>">
                <ul>
					<?php
					wp_list_categories( array(
						'taxonomy'           => $taxonomy,
						'orderby'            => 'none',
						'order'              => 'ASC',
						'show_count'         => 0,
						'pad_counts'         => 0,
						'depth'              => 3,
						'hide_empty'         => 0,
						'use_desc_for_title' => 0,
						'title_li'           => '',
						'show_option_none'   => ''
					) );
					?>
                </ul>
            </nav>

			<?php
		}

	}

}

/*
====================================================================================================
Get Terms
====================================================================================================
*/

if ( ! function_exists( 'linguini_terms' ) ) {

	function linguini_terms( $taxonomy = 'category', $link = 1, $container = 'div' ) {

		if ( get_terms( array( 'taxonomy' => $taxonomy ) ) ) {

			$terms = get_terms( array(
				'taxonomy'     => $taxonomy,
				'orderby'      => 'name',
				'order'        => 'ASC',
				'hide_empty'   => 1,
				'number'       => '',
				'fields'       => 'all',
				'slug'         => '',
				'parent'       => '',
				'hierarchical' => true,
				'child_of'     => 0,
				'get'          => '',
				'name__like'   => '',
				'pad_counts'   => false,
				'offset'       => '',
				'search'       => '',
				'cache_domain' => 'core'
			) );

			if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
				$count     = count( $terms );
				$i         = 0;
				$term_list = '<' . $container . ' class="fy-terms">';

				foreach ( $terms as $term ) {
					$i ++;
					if ( $container == 'ul' ) {
						$term_list .= '<li class="fy-term-item">';
					} else {
						$term_list .= '<span class="fy-term-item">';
					}

					if ( $link != 0 ) {
						$term_list .= '<a href="' . get_term_link( $term ) . '" title="' . $term->name . '">';
					}
					$term_list .= $term->name;
					if ( $link != 0 ) {
						$term_list .= '</a>';
					}
					if ( $container != 'ul' ) {
						if ( $count != $i ) {
							$term_list .= ', ';
						}
					}

					if ( $container == 'ul' ) {
						$term_list .= '</li>';
					} else {
						$term_list .= '</span>';
					}
				}

				$term_list .= '</' . $container . '>';

				echo $term_list;

			}

		}

	}

}

/*
====================================================================================================
Get Terms for Post
====================================================================================================
*/

if ( ! function_exists( 'linguini_terms_post' ) ) {

	function linguini_terms_post( $post_id = '', $taxonomy = 'category', $link = 1 ) {

		$terms = wp_get_post_terms( $post_id, $taxonomy, array(
			'orderby' => 'term_order'
		) );

		if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
			$i = 0;

			$term_list = '<ul class="fy-terms">';
			$separator = ', ';

			foreach ( $terms as $term ) {
				$i ++;

				$term_list .= '<li class="fy-term-item">';

				if ( $link != 0 ) {
					$term_list .= '<a href="' . get_term_link( $term ) . '" title="' . $term->name . '">' . $term->name . '</a>' . '<span class="fy-separator">' . $separator . '</span>';
				} else {
					$term_list .= $term->name . '<span class="fy-separator">' . $separator . '</span>';
				}

				$term_list .= '</li>';
			}

			$term_list .= '</ul>';

			echo $term_list;
		}


	}

}

/*
====================================================================================================
Remove current_page_item Class
====================================================================================================
*/

if ( ! function_exists( 'linguini_current_page_item_remove' ) ) {

	function linguini_current_page_item_remove( $classes, $item ) {

		$post_type = get_query_var( 'post_type' );

		if ( get_post_type() == $post_type ) {
			$classes = array_filter( $classes, "get_current_value" );
		}

		if ( is_search() ) {
			$classes = array_filter( $classes, "get_current_value" );
		}

		if ( is_tax() ) {
			$classes = array_filter( $classes, "get_current_value" );
		}

		return $classes;

	}

	function get_current_value( $element ) {
		return ( $element != "current_page_parent" );
	}

	add_filter( 'nav_menu_css_class', 'linguini_current_page_item_remove', 10, 2 );

}

/*
====================================================================================================
Add current_page_item Class for CPT Menu Item
====================================================================================================
*/

if ( ! function_exists( 'linguini_current_page_item_add' ) ) {

	function linguini_current_page_item_add( $classes = array(), $menu_item = false ) {

		$post_type     = get_post_type();
		$page_template = get_post_meta( $menu_item->object_id, '_wp_page_template', true );

		// Menu
		if ( is_single() && $post_type == 'menu' && $page_template == 'template-menu.php' ) {
			$classes[] = 'current_page_item';
		}
		if ( is_tax( 'section' ) && $page_template == 'template-menu.php' ) {
			$classes[] = 'current_page_item';
		}

		// Event
		if ( is_single() && $post_type == 'event' && $page_template == 'template-event.php' ) {
			$classes[] = 'current_page_item';
		}
		if ( is_tax( 'category-event' ) && $page_template == 'template-event.php' ) {
			$classes[] = 'current_page_item';
		}

		// Gallery
		if ( is_single() && $post_type == 'gallery' && $page_template == 'template-gallery.php' ) {
			$classes[] = 'current_page_item';
		}
		if ( is_tax( 'category-gallery' ) && $page_template == 'template-gallery.php' ) {
			$classes[] = 'current_page_item';
		}

		return $classes;

	}

	add_filter( 'nav_menu_css_class', 'linguini_current_page_item_add', 10, 2 );

}
