<?php

/*

Theme Images Functions

*/

/*
====================================================================================================
Add Image Sizes
====================================================================================================
*/

// Medium
add_image_size( 'fy-medium-fixed', 800, 600, array( 'center', 'center' ) );
// xLarge
add_image_size( 'fy-xlarge-fixed', 1600, 1200, array( 'center', 'center' ) );
// Huge
add_image_size( 'fy-huge', 1920, '', array( 'center', 'center' ) );

/*
====================================================================================================
Lazy loading 'data-src', 'data-srcset', 'data-sizes' on frontend images
====================================================================================================
*/

if ( ! is_admin() ) {

	if ( ! function_exists( 'linguini_theme_image_attributes' ) ) {

		function linguini_theme_image_attributes( $attr ) {

			$src         = $attr['src'];
			$placeholder = trailingslashit( get_template_directory_uri() ) . 'images/placeholder.png';

			if ( isset( $attr['sizes'] ) ) {
				$data_sizes = $attr['sizes'];
				unset( $attr['sizes'] );
				$attr['data-sizes'] = $data_sizes;
			}

			if ( isset( $attr['srcset'] ) ) {
				$data_srcset = $attr['srcset'];
				unset( $attr['srcset'] );
				$attr['data-srcset']   = $data_srcset;
				$attr['data-noscript'] = $attr['src'];
				unset( $attr['src'] );
			}

			$attr['class']    = 'fy-image fy-image-responsive js-lazy';
			$attr['src']      = $placeholder;
			$attr['data-src'] = $src;

			return $attr;
		}

		add_filter( 'wp_get_attachment_image_attributes', 'linguini_theme_image_attributes', 10, 2 );

	}

}
