<?php

/*

Theme Fonts Functions

*/

if ( ! function_exists( 'linguini_theme_fonts' ) ) {

	function linguini_theme_fonts() {

		if ( ! is_admin() ) {

			// Primary Font

			$font_primary_option = get_theme_mod( 'fy_font_primary', linguini_default( 'fy_font_primary' ) );
			$font_primary        = str_replace( ' ', '+', $font_primary_option );

			$font_primary_styles_option = get_theme_mod( 'fy_font_primary_styles', linguini_default( 'fy_font_primary_styles' ) );
			$font_primary_styles_clean  = str_replace( ' ', '', $font_primary_styles_option );
			$font_primary_styles        = ':' . $font_primary_styles_clean;

			// Secondary Font

			$font_secondary_option = get_theme_mod( 'fy_font_secondary', linguini_default( 'fy_font_secondary' ) );
			$font_secondary        = str_replace( ' ', '+', $font_secondary_option );

			$font_secondary_styles_option = get_theme_mod( 'fy_font_secondary_styles', linguini_default( 'fy_font_secondary_styles' ) );
			$font_secondary_styles_clean  = str_replace( ' ', '', $font_secondary_styles_option );
			$font_secondary_styles        = ':' . $font_secondary_styles_clean;

			// Enqueue Fonts [Google Fonts API]

			wp_enqueue_style( 'google-fonts', '//fonts.googleapis.com/css?family=' . $font_primary . $font_primary_styles . '|' . $font_secondary . $font_secondary_styles . '&display=swap' );

		}

	}

	add_action( 'wp_enqueue_scripts', 'linguini_theme_fonts', 1, 1 );

}
