<?php

/*

Customize Title & Tagline

*/

/*
----------------------------------------------------------------------------------------------------
Change Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_change_section_title' ) ) {

	function linguini_customize_change_section_title( $wp_customize ) {
		$wp_customize->get_section( 'title_tagline' )->priority = 20;
	}

	add_action( 'customize_register', 'linguini_customize_change_section_title' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_title' ) ) {

	function linguini_customize_add_settings_title( $wp_customize ) {

		// Logo

		$wp_customize->add_setting( 'fy_logo_text', array(
			'default'           => get_bloginfo( 'name' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_logo_image', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_loading_image', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_title' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_title' ) ) {

	function linguini_customize_add_controls_title( $wp_customize ) {

		// Logo

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_logo_text', array(
			'label'       => esc_html__( 'Logo Text', 'linguini' ),
			'description' => esc_html__( 'Fill the name of your site.', 'linguini' ),
			'settings'    => 'fy_logo_text',
			'section'     => 'title_tagline',
		) ) );

		$wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, 'fy_logo_image', array(
			'label'       => esc_html__( 'Logo Image', 'linguini' ),
			'description' => esc_html__( 'Upload a logo image. Required size at least 400px of width.', 'linguini' ),
			'settings'    => 'fy_logo_image',
			'section'     => 'title_tagline',
		) ) );

		$wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, 'fy_loading_image', array(
			'label'       => esc_html__( 'Loading Image', 'linguini' ),
			'description' => esc_html__( 'Upload a loading image. Required size is 144x144 pixels.', 'linguini' ),
			'settings'    => 'fy_loading_image',
			'section'     => 'title_tagline',
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_title' );
}
