<?php

/*

Customize Slideshow

*/

/*
----------------------------------------------------------------------------------------------------
Add Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_section_slideshow' ) ) {

	function linguini_customize_add_section_slideshow( $wp_customize ) {

		$wp_customize->add_section(
			'slideshow',
			array(
				'title'    => esc_html__( 'Slideshow', 'linguini' ),
				'priority' => 81,
			)
		);

	}

	add_action( 'customize_register', 'linguini_customize_add_section_slideshow' );

}

/*
----------------------------------------------------------------------------------------------------
Add Slideshow
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_slideshow_slideshow' ) ) {

	function linguini_customize_add_slideshow_slideshow( $wp_customize ) {

		$wp_customize->add_setting( 'fy_slideshow_color', array(
			'default'           => linguini_default( 'fy_slideshow_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_color_accent', array(
			'default'           => linguini_default( 'fy_slideshow_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_color_background', array(
			'default'           => linguini_default( 'fy_slideshow_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Overlay
		$wp_customize->add_setting( 'fy_slideshow_overlay_color', array(
			'default'           => linguini_default( 'fy_slideshow_overlay_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_overlay_opacity', array(
			'default'           => linguini_default( 'fy_slideshow_overlay_opacity' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Settings
		$wp_customize->add_setting( 'fy_slideshow_settings_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_direction', array(
			'default'           => linguini_default( 'fy_slideshow_direction' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_effect', array(
			'default'           => linguini_default( 'fy_slideshow_effect' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_loop', array(
			'default'           => linguini_default( 'fy_slideshow_loop' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_speed', array(
			'default'           => linguini_default( 'fy_slideshow_speed' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_autoplay', array(
			'default'           => linguini_default( 'fy_slideshow_autoplay' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Badge
		$wp_customize->add_setting( 'fy_slideshow_badge_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_badge', array(
			'default'           => 0,
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_badge_text', array(
			'default'           => esc_html__( 'Book a table online', 'linguini' ),
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_setting( 'fy_slideshow_badge_link', array(
			'default'           => '0',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_slideshow_badge_link_custom', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_setting( 'fy_badge_color', array(
			'default'           => linguini_default( 'fy_badge_color' ),
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_setting( 'fy_badge_color_accent', array(
			'default'           => linguini_default( 'fy_badge_color_accent' ),
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_setting( 'fy_badge_color_background', array(
			'default'           => linguini_default( 'fy_badge_color_background' ),
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->selective_refresh->add_partial( 'fy_slideshow_badge_text', array(
			'selector' => '.cs-badge'
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_slideshow_slideshow' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_slideshow' ) ) {

	function linguini_customize_add_controls_slideshow( $wp_customize ) {

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_slideshow_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_slideshow_color',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_slideshow_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_slideshow_color_accent',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_slideshow_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_slideshow_color_background',
			'section'  => 'slideshow',
		) ) );

		// Overlay
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_slideshow_overlay_color', array(
			'label'    => esc_html__( 'Overlay Color', 'linguini' ),
			'settings' => 'fy_slideshow_overlay_color',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_overlay_opacity', array(
			'label'    => esc_html__( 'Overlay Opacity', 'linguini' ),
			'settings' => 'fy_slideshow_overlay_opacity',
			'section'  => 'slideshow',
			'type'     => 'select',
			'choices'  => array(
				'95' => '95%',
				'90' => '90%',
				'85' => '85%',
				'80' => '80%',
				'75' => '75%',
				'70' => '70%',
				'65' => '65%',
				'60' => '60%',
				'55' => '55%',
				'50' => '50%',
				'45' => '45%',
				'40' => '40%',
				'35' => '35%',
				'30' => '30%',
				'25' => '25%',
				'20' => '20%',
				'15' => '15%',
				'10' => '10%',
				'5'  => '5%',
				'0'  => '0%',
			),
		) ) );

		// Settings
		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slideshow_settings_heading', array(
				'label'   => esc_html__( 'Settings', 'linguini' ),
				'type'    => 'heading',
				'section' => 'slideshow',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_direction', array(
			'label'    => esc_html__( 'Direction', 'linguini' ),
			'settings' => 'fy_slideshow_direction',
			'section'  => 'slideshow',
			'type'     => 'select',
			'choices'  => array(
				'horizontal' => esc_html__( 'Horizontal', 'linguini' ),
				'vertical'   => esc_html__( 'Vertical', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_effect', array(
			'label'    => esc_html__( 'Effect', 'linguini' ),
			'settings' => 'fy_slideshow_effect',
			'section'  => 'slideshow',
			'type'     => 'select',
			'choices'  => array(
				'slide' => esc_html__( 'Slide', 'linguini' ),
				'fade'  => esc_html__( 'Fade', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_loop', array(
			'label'    => esc_html__( 'Loop', 'linguini' ),
			'settings' => 'fy_slideshow_loop',
			'section'  => 'slideshow',
			'type'     => 'select',
			'choices'  => array(
				'true'  => esc_html__( 'Enabled', 'linguini' ),
				'false' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_speed', array(
			'label'       => esc_html__( 'Speed', 'linguini' ),
			'description' => esc_html__( 'Duration of transition between slides in milliseconds.', 'linguini' ),
			'settings'    => 'fy_slideshow_speed',
			'section'     => 'slideshow',
			'type'        => 'number',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_autoplay', array(
			'label'    => esc_html__( 'Autoplay', 'linguini' ),
			'settings' => 'fy_slideshow_autoplay',
			'type'     => 'number',
			'section'  => 'slideshow',
		) ) );

		// Badge
		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slideshow_badge_heading', array(
				'label'   => esc_html__( 'Badge', 'linguini' ),
				'type'    => 'heading',
				'section' => 'slideshow',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_badge', array(
			'label'    => esc_html__( 'Badge?', 'linguini' ),
			'settings' => 'fy_slideshow_badge',
			'type'     => 'checkbox',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_badge_text', array(
			'label'    => esc_html__( 'Text', 'linguini' ),
			'settings' => 'fy_slideshow_badge_text',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_badge_link', array(
			'label'    => esc_html__( 'Link to Page', 'linguini' ),
			'settings' => 'fy_slideshow_badge_link',
			'type'     => 'dropdown-pages',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slideshow_badge_link_custom', array(
			'label'    => esc_html__( 'Custom Link', 'linguini' ),
			'settings' => 'fy_slideshow_badge_link_custom',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_badge_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_badge_color',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_badge_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_badge_color_accent',
			'section'  => 'slideshow',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_badge_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_badge_color_background',
			'section'  => 'slideshow',
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_slideshow' );

}