<?php

/*

Customize Settings

*/

/*
----------------------------------------------------------------------------------------------------
Add Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_section_settings' ) ) {

	function linguini_customize_add_section_settings( $wp_customize ) {

		$wp_customize->add_section(
			'settings',
			array(
				'title'    => esc_html__( 'Settings', 'linguini' ),
				'priority' => 191,
			)
		);

	}

	add_action( 'customize_register', 'linguini_customize_add_section_settings' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_settings' ) ) {

	function linguini_customize_add_settings_settings( $wp_customize ) {

		// Loading
		$wp_customize->add_setting( 'fy_loading', array(
			'default'           => 'enabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Event
		$wp_customize->add_setting( 'fy_event_date_format', array(
			'default'           => linguini_default( 'fy_event_date_format' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_event_date_delimiter', array(
			'default'           => linguini_default( 'fy_event_date_delimiter' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Menu
		$wp_customize->add_setting( 'fy_menu_single', array(
			'default'           => 'disabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_menu_filter_by_ingredients', array(
			'default'           => 'enabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_settings' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_settings' ) ) {

	function linguini_customize_add_controls_settings( $wp_customize ) {

		// Loading
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_loading', array(
			'label'       => esc_html__( 'Loading', 'linguini' ),
			'description' => esc_html__( 'Enable/disable the page loading.', 'linguini' ),
			'settings'    => 'fy_loading',
			'section'     => 'settings',
			'type'        => 'select',
			'choices'     => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );

		// Event
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_event_date_format', array(
			'label'    => esc_html__( 'Date Format', 'linguini' ),
			'settings' => 'fy_event_date_format',
			'section'  => 'settings',
			'type'     => 'select',
			'choices'  => array(
				'd m Y'    => 'd m Y',
				'm d Y'    => 'm d Y',
				'Y m d'    => 'Y m d',
				'Y d m'    => 'Y d m',
				'l, j m Y' => 'l, j m Y',
				'F j, Y'   => 'F j, Y',
				'j M, Y'   => 'j M, Y',
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_event_date_delimiter', array(
			'label'    => esc_html__( 'Date Delimiter', 'linguini' ),
			'settings' => 'fy_event_date_delimiter',
			'section'  => 'settings',
			'type'     => 'select',
			'choices'  => array(
				'&nbsp;' => esc_html__( 'Space', 'linguini' ),
				'/'      => '/',
				'.'      => '.',
				'-'      => '-',
			),
		) ) );

		// Menu
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_menu_single', array(
			'label'    => esc_html__( 'Menu Item Single Pages', 'linguini' ),
			'settings' => 'fy_menu_single',
			'section'  => 'settings',
			'type'     => 'select',
			'choices'  => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_menu_filter_by_ingredients', array(
			'label'    => esc_html__( 'Menu Filter by Ingredients', 'linguini' ),
			'settings' => 'fy_menu_filter_by_ingredients',
			'section'  => 'settings',
			'type'     => 'select',
			'choices'  => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_settings' );

}