<?php

/*

Customize Settings

*/

/*
----------------------------------------------------------------------------------------------------
Add Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_section_homepage' ) ) {

	function linguini_customize_add_section_homepage( $wp_customize ) {

		$wp_customize->add_section(
			'homepage',
			array(
				'title'    => esc_html__( 'Homepage', 'linguini' ),
				'priority' => 82,
			)
		);

	}

	add_action( 'customize_register', 'linguini_customize_add_section_homepage' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_homepage' ) ) {

	function linguini_customize_add_settings_homepage( $wp_customize ) {

		// About
		$wp_customize->add_setting( 'fy_homepage_about_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_homepage_about', array(
			'default'           => 'enabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Posts
		$wp_customize->add_setting( 'fy_homepage_posts_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_homepage_posts', array(
			'default'           => 'enabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_homepage_posts_count', array(
			'default'           => linguini_default( 'fy_homepage_posts_count' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Events
		$wp_customize->add_setting( 'fy_homepage_events_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_homepage_events', array(
			'default'           => 'enabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_homepage_events_count', array(
			'default'           => linguini_default( 'fy_homepage_events_count' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_homepage' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_homepage' ) ) {

	function linguini_customize_add_controls_homepage( $wp_customize ) {

		// About
		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_homepage_about_heading', array(
				'label'   => esc_html__( 'About', 'linguini' ),
				'type'    => 'heading',
				'section' => 'homepage',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_homepage_about', array(
			'label'       => esc_html__( 'About', 'linguini' ),
			'description' => esc_html__( 'Enable/disable displaying of about section on the homepage.', 'linguini' ),
			'settings'    => 'fy_homepage_about',
			'section'     => 'homepage',
			'type'        => 'select',
			'choices'     => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );

		// Posts
		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_homepage_posts_heading', array(
				'label'   => esc_html__( 'Posts', 'linguini' ),
				'type'    => 'heading',
				'section' => 'homepage',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_homepage_posts', array(
			'label'       => esc_html__( 'Posts', 'linguini' ),
			'description' => esc_html__( 'Enable/disable displaying of posts on the homepage.', 'linguini' ),
			'settings'    => 'fy_homepage_posts',
			'section'     => 'homepage',
			'type'        => 'select',
			'choices'     => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_homepage_posts_count', array(
			'label'       => esc_html__( 'Number of Items', 'linguini' ),
			'settings'    => 'fy_homepage_posts_count',
			'section'     => 'homepage',
			'type'        => 'number',
			'input_attrs' => array(
				'min'  => - 1,
				'max'  => 20,
				'step' => 1,
			),
		) ) );

		// Events
		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_homepage_events_heading', array(
				'label'   => esc_html__( 'Events', 'linguini' ),
				'type'    => 'heading',
				'section' => 'homepage',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_homepage_events', array(
			'label'       => esc_html__( 'Events', 'linguini' ),
			'description' => esc_html__( 'Enable/disable displaying of events on the homepage.', 'linguini' ),
			'settings'    => 'fy_homepage_events',
			'section'     => 'homepage',
			'type'        => 'select',
			'choices'     => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_homepage_events_count', array(
			'label'       => esc_html__( 'Number of Items', 'linguini' ),
			'settings'    => 'fy_homepage_events_count',
			'section'     => 'homepage',
			'type'        => 'number',
			'input_attrs' => array(
				'min'  => - 1,
				'max'  => 20,
				'step' => 1,
			),
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_homepage' );

}