<?php

/*

Customize Header

*/

/*
----------------------------------------------------------------------------------------------------
Change Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_change_section_header' ) ) {

	function linguini_customize_change_section_header( $wp_customize ) {
		$wp_customize->get_section( 'header_image' )->title = esc_html__( 'Header', 'linguini' );
	}

	add_action( 'customize_register', 'linguini_customize_change_section_header' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_header' ) ) {

	function linguini_customize_add_settings_header( $wp_customize ) {

		/**
		 *
		 * Header
		 *
		 */

		// Overlay
		$wp_customize->add_setting( 'fy_header_overlay_color', array(
			'default'           => linguini_default( 'fy_header_overlay_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_header_overlay_opacity', array(
			'default'           => linguini_default( 'fy_header_overlay_opacity' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_header' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_header' ) ) {

	function linguini_customize_add_controls_header( $wp_customize ) {

		/**
		 *
		 * Header
		 *
		 */

		// Overlay
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_header_overlay_color', array(
			'label'    => esc_html__( 'Overlay Color', 'linguini' ),
			'settings' => 'fy_header_overlay_color',
			'section'  => 'header_image',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_header_overlay_opacity', array(
			'label'    => esc_html__( 'Overlay Opacity', 'linguini' ),
			'settings' => 'fy_header_overlay_opacity',
			'section'  => 'header_image',
			'type'     => 'select',
			'choices'  => array(
				'95' => '95%',
				'90' => '90%',
				'85' => '85%',
				'80' => '80%',
				'75' => '75%',
				'70' => '70%',
				'65' => '65%',
				'60' => '60%',
				'55' => '55%',
				'50' => '50%',
				'45' => '45%',
				'40' => '40%',
				'35' => '35%',
				'30' => '30%',
				'25' => '25%',
				'20' => '20%',
				'15' => '15%',
				'10' => '10%',
				'5'  => '5%',
				'0'  => '0%',
			),
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_header' );

}
