<?php

/*

Customize Static Front Page

*/

/*
----------------------------------------------------------------------------------------------------
Change Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_change_section_frontpage' ) ) {

	function linguini_customize_change_section_frontpage( $wp_customize ) {
		$wp_customize->get_section( 'static_front_page' )->priority = 190;
	}

	add_action( 'customize_register', 'linguini_customize_change_section_frontpage' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_frontpage' ) ) {

	function linguini_customize_add_settings_frontpage( $wp_customize ) {

		$wp_customize->add_setting( 'fy_page_reservation', array(
			'default'           => '0',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_page_about', array(
			'default'           => '0',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_page_menu', array(
			'default'           => '0',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_page_events', array(
			'default'           => '0',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_frontpage' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_frontpage' ) ) {

	function linguini_customize_add_controls_frontpage( $wp_customize ) {

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_page_reservation', array(
			'label'    => esc_html__( 'Reservations page', 'linguini' ),
			'settings' => 'fy_page_reservation',
			'type'     => 'dropdown-pages',
			'section'  => 'static_front_page',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_page_about', array(
			'label'    => esc_html__( 'About page', 'linguini' ),
			'settings' => 'fy_page_about',
			'type'     => 'dropdown-pages',
			'section'  => 'static_front_page',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_page_menu', array(
			'label'    => esc_html__( 'Menu page', 'linguini' ),
			'settings' => 'fy_page_menu',
			'type'     => 'dropdown-pages',
			'section'  => 'static_front_page',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_page_events', array(
			'label'    => esc_html__( 'Events page', 'linguini' ),
			'settings' => 'fy_page_events',
			'type'     => 'dropdown-pages',
			'section'  => 'static_front_page',
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_frontpage' );

}