<?php

/*

Customize Footer

*/

/*
----------------------------------------------------------------------------------------------------
Add Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_section_footer' ) ) {

	function linguini_customize_add_section_footer( $wp_customize ) {

		$wp_customize->add_section(
			'footer',
			array(
				'title'    => esc_html__( 'Footer', 'linguini' ),
				'priority' => 95,
			)
		);

	}

	add_action( 'customize_register', 'linguini_customize_add_section_footer' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_footer' ) ) {

	function linguini_customize_add_settings_footer( $wp_customize ) {

		$wp_customize->add_setting( 'fy_copyright', array(
			'default'           => 'All rights reserved.',
			'transport'         => 'refresh',
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_setting( 'fy_themeby', array(
			'default'           => '1',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_footer' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_footer' ) ) {

	function linguini_customize_add_controls_footer( $wp_customize ) {

		// Copyright
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_copyright', array(
			'label'    => esc_html__( 'Copyright', 'linguini' ),
			'settings' => 'fy_copyright',
			'type'     => 'textarea',
			'section'  => 'footer',
		) ) );

		// Theme by
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_themeby', array(
			'label'    => esc_html__( 'Theme by', 'linguini' ),
			'settings' => 'fy_themeby',
			'type'     => 'checkbox',
			'section'  => 'footer',
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_footer' );

}