<?php

/*

Customize Fonts

*/

/*
----------------------------------------------------------------------------------------------------
Add Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_section_fonts' ) ) {

	function linguini_customize_add_section_fonts( $wp_customize ) {

		$fontsUrl = 'https://fonts.google.com/';

		$wp_customize->add_section(
			'fonts',
			array(
				'title'       => esc_html__( 'Fonts', 'linguini' ),
				'description' => sprintf( wp_kses( __( 'First, please choose the fonts by your choice from <a href="%s" target="_blank">Google Fonts</a>', 'linguini' ), array(
					'a' => array(
						'href'   => array(),
						'target' => array()
					)
				) ), esc_url( $fontsUrl ) ),
				'priority'    => 43,
			)
		);

	}

	add_action( 'customize_register', 'linguini_customize_add_section_fonts' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_fonts' ) ) {

	function linguini_customize_add_settings_fonts( $wp_customize ) {

		$wp_customize->add_setting( 'fy_font_primary', array(
			'default'           => linguini_default( 'fy_font_primary' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_font_primary_styles', array(
			'default'           => linguini_default( 'fy_font_primary_styles' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_font_secondary', array(
			'default'           => linguini_default( 'fy_font_secondary' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_font_secondary_styles', array(
			'default'           => linguini_default( 'fy_font_secondary_styles' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_font_size', array(
			'default'           => linguini_default( 'fy_font_size' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_letter_spacing', array(
			'default'           => linguini_default( 'fy_letter_spacing' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_text_transform', array(
			'default'           => linguini_default( 'fy_text_transform' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_fonts' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_fonts' ) ) {

	function linguini_customize_add_controls_fonts( $wp_customize ) {

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_font_primary', array(
			'label'       => esc_html__( 'Primary Font', 'linguini' ),
			'description' => esc_html__( 'Fill a full name of the font from Google Fonts.', 'linguini' ),
			'settings'    => 'fy_font_primary',
			'section'     => 'fonts',
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_font_primary_styles', array(
			'label'       => esc_html__( 'Primary Font Styles', 'linguini' ),
			'description' => esc_html__( 'Fill the styles you want to use with the primary font.', 'linguini' ),
			'settings'    => 'fy_font_primary_styles',
			'section'     => 'fonts',
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_font_secondary', array(
			'label'       => esc_html__( 'Secondary Font', 'linguini' ),
			'description' => esc_html__( 'Fill a full name of the font from Google Fonts.', 'linguini' ),
			'settings'    => 'fy_font_secondary',
			'section'     => 'fonts',
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_font_secondary_styles', array(
			'label'       => esc_html__( 'Secondary Font Styles', 'linguini' ),
			'description' => esc_html__( 'Fill the styles you want to use with the secondary font.', 'linguini' ),
			'settings'    => 'fy_font_secondary_styles',
			'section'     => 'fonts',
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_font_size', array(
			'label'    => esc_html__( 'Base Font Size', 'linguini' ),
			'settings' => 'fy_font_size',
			'type'     => 'select',
			'section'  => 'fonts',
			'choices'  => array(
				'12px' => '12px',
				'13px' => '13px',
				'14px' => '14px',
				'15px' => '15px',
				'16px' => '16px',
				'17px' => '17px',
				'18px' => '18px',
				'19px' => '19px',
				'20px' => '20px',
			),
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_letter_spacing', array(
			'label'    => esc_html__( 'Letter Spacing', 'linguini' ),
			'settings' => 'fy_letter_spacing',
			'type'     => 'select',
			'section'  => 'fonts',
			'choices'  => array(
				'-2px'     => '-2px',
				'-0.1em'   => '-0.1em',
				'-1px'     => '-1px',
				'-0.05em'  => '-0.05em',
				'-0.025em' => '-0.025em',
				'0px'      => '0px',
				'0.025em'  => '0.025em',
				'0.05em'   => '0.05em',
				'1px'      => '1px',
				'0.1em'    => '0.1em',
				'2px'      => '2px',
			),
		) ) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_text_transform', array(
			'label'    => esc_html__( 'Text Transform', 'linguini' ),
			'settings' => 'fy_text_transform',
			'type'     => 'select',
			'section'  => 'fonts',
			'choices'  => array(
				'none'       => 'None',
				'uppercase'  => 'Uppercase',
				'capitalize' => 'Capitalize',
			),
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_fonts' );

}