<?php

/*

Customize Colors

*/

/*
----------------------------------------------------------------------------------------------------
Change Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_change_section_colors' ) ) {

	function linguini_customize_change_section_colors( $wp_customize ) {
		$wp_customize->get_section( 'colors' )->title       = esc_html__( 'Design', 'linguini' );
		$wp_customize->get_section( 'colors' )->description = esc_html__( 'Customize the design of the theme to fit the needs of your brand.', 'linguini' );
		$wp_customize->get_section( 'colors' )->priority    = 42;

		// remove default wp background_color control
		$wp_customize->remove_control( 'background_color' );
	}

	add_action( 'customize_register', 'linguini_customize_change_section_colors' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_colors' ) ) {

	function linguini_customize_add_settings_colors( $wp_customize ) {

		/**
		 *
		 * Header
		 *
		 */

		$wp_customize->add_setting( 'fy_header_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_header_color', array(
			'default'           => linguini_default( 'fy_header_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_header_color_accent', array(
			'default'           => linguini_default( 'fy_header_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_header_color_background', array(
			'default'           => linguini_default( 'fy_header_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Navigation
		 *
		 */

		$wp_customize->add_setting( 'fy_navigation_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_color', array(
			'default'           => linguini_default( 'fy_navigation_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_color_accent', array(
			'default'           => linguini_default( 'fy_navigation_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_color_background', array(
			'default'           => linguini_default( 'fy_navigation_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Sticky

		$wp_customize->add_setting( 'fy_sticky_navigation_subheading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sticky', array(
			'default'           => linguini_default( 'fy_navigation_sticky' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sticky_color', array(
			'default'           => linguini_default( 'fy_navigation_sticky_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sticky_color_accent', array(
			'default'           => linguini_default( 'fy_navigation_sticky_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sticky_color_background', array(
			'default'           => linguini_default( 'fy_navigation_sticky_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Sub-navigation

		$wp_customize->add_setting( 'fy_sub_navigation_subheading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sub_color', array(
			'default'           => linguini_default( 'fy_navigation_sub_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sub_color_accent', array(
			'default'           => linguini_default( 'fy_navigation_sub_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_navigation_sub_color_background', array(
			'default'           => linguini_default( 'fy_navigation_sub_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Heading
		 *
		 */

		$wp_customize->add_setting( 'fy_heading_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_heading_color', array(
			'default'           => linguini_default( 'fy_heading_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_heading_color_accent', array(
			'default'           => linguini_default( 'fy_heading_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_heading_color_background', array(
			'default'           => linguini_default( 'fy_heading_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * About
		 *
		 */

		$wp_customize->add_setting( 'fy_about_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_about_color', array(
			'default'           => linguini_default( 'fy_about_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_about_color_accent', array(
			'default'           => linguini_default( 'fy_about_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_about_color_background', array(
			'default'           => linguini_default( 'fy_about_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Content
		 *
		 */

		$wp_customize->add_setting( 'fy_content_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_content_color', array(
			'default'           => linguini_default( 'fy_content_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_content_color_opacity', array(
			'default'           => linguini_default( 'fy_content_color_opacity' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_content_color_accent', array(
			'default'           => linguini_default( 'fy_content_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_content_color_background', array(
			'default'           => linguini_default( 'fy_content_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Footer
		 *
		 */

		$wp_customize->add_setting( 'fy_footer_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_footer_color', array(
			'default'           => linguini_default( 'fy_footer_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_footer_color_accent', array(
			'default'           => linguini_default( 'fy_footer_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_footer_color_background', array(
			'default'           => linguini_default( 'fy_footer_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Footer Widgets
		$wp_customize->add_setting( 'fy_footer_widgets_subheading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_footer_widgets_color', array(
			'default'           => linguini_default( 'fy_footer_widgets_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_footer_widgets_color_accent', array(
			'default'           => linguini_default( 'fy_footer_widgets_color_accent' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_footer_widgets_color_background', array(
			'default'           => linguini_default( 'fy_footer_widgets_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Lightbox
		 *
		 */

		$wp_customize->add_setting( 'fy_lightbox_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_lightbox_color', array(
			'default'           => linguini_default( 'fy_lightbox_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_lightbox_color_background', array(
			'default'           => linguini_default( 'fy_lightbox_color_background' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * State
		 *
		 */

		$wp_customize->add_setting( 'fy_state_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_error_color', array(
			'default'           => linguini_default( 'fy_error_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_success_color', array(
			'default'           => linguini_default( 'fy_success_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Overlay
		 *
		 */

		$wp_customize->add_setting( 'fy_overlay_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_overlay_color', array(
			'default'           => linguini_default( 'fy_overlay_color' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_overlay_opacity', array(
			'default'           => linguini_default( 'fy_overlay_opacity' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		/**
		 *
		 * Shadows
		 *
		 */

		$wp_customize->add_setting( 'fy_shadows_heading', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_style_shadow', array(
			'default'           => 'enabled',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_settings_colors' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_colors' ) ) {

	function linguini_customize_add_controls_colors( $wp_customize ) {

		/**
		 *
		 * Header
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_header_heading', array(
				'label'   => esc_html__( 'Header', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_header_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_header_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_header_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_header_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_header_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_header_color_background',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * Navigation
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_navigation_heading', array(
				'label'   => esc_html__( 'Navigation', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_navigation_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_navigation_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_navigation_color_background',
			'section'  => 'colors',
		) ) );

		// Sticky

		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_sticky_navigation_subheading', array(
				'label'   => esc_html__( 'Sticky', 'linguini' ),
				'type'    => 'subheading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_navigation_sticky', array(
			'label'       => esc_html__( 'Sticky', 'linguini' ),
			'description' => esc_html__( 'Enable/disable sticking of the navigation.', 'linguini' ),
			'settings'    => 'fy_navigation_sticky',
			'section'     => 'colors',
			'type'        => 'select',
			'choices'     => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_sticky_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_navigation_sticky_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_sticky_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_navigation_sticky_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_sticky_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_navigation_sticky_color_background',
			'section'  => 'colors',
		) ) );

		// Sub-navigation

		if ( class_exists( 'forqy_Customize_Subheading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Subheading_Control( $wp_customize, 'fy_sub_navigation_subheading', array(
				'label'   => esc_html__( 'Sub-navigation', 'linguini' ),
				'type'    => 'subheading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_sub_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_navigation_sub_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_sub_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_navigation_sub_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_navigation_sub_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_navigation_sub_color_background',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * Heading
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_heading_heading', array(
				'label'   => esc_html__( 'Heading', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_heading_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_heading_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_heading_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_heading_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_heading_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_heading_color_background',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * About
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_about_heading', array(
				'label'   => esc_html__( 'About', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_about_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_about_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_about_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_about_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_about_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_about_color_background',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * Content
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_content_heading', array(
				'label'   => esc_html__( 'Content', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_content_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_content_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_content_color_opacity', array(
			'label'    => esc_html__( 'Color Opacity', 'linguini' ),
			'settings' => 'fy_content_color_opacity',
			'section'  => 'colors',
			'type'     => 'select',
			'choices'  => array(
				'100' => '100%',
				'95'  => '95%',
				'90'  => '90%',
				'85'  => '85%',
				'80'  => '80%',
				'75'  => '75%',
				'70'  => '70%',
				'65'  => '65%',
				'60'  => '60%',
				'55'  => '55%',
				'50'  => '50%',
				'45'  => '45%',
				'40'  => '40%',
				'35'  => '35%',
				'30'  => '30%',
				'25'  => '25%',
				'20'  => '20%',
				'15'  => '15%',
				'10'  => '10%',
				'5'   => '5%',
				'0'   => '0%',
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_content_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_content_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_content_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_content_color_background',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * Footer
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_footer_heading', array(
				'label'   => esc_html__( 'Footer', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_footer_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_footer_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_footer_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_footer_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_footer_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_footer_color_background',
			'section'  => 'colors',
		) ) );

		// Footer Widgets
		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_footer_widgets_subheading', array(
				'label'   => esc_html__( 'Footer Widgets', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_footer_widgets_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_footer_widgets_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_footer_widgets_color_accent', array(
			'label'    => esc_html__( 'Accent Color', 'linguini' ),
			'settings' => 'fy_footer_widgets_color_accent',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_footer_widgets_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_footer_widgets_color_background',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * Lightbox
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_lightbox_heading', array(
				'label'   => esc_html__( 'Lightbox', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_lightbox_color', array(
			'label'    => esc_html__( 'Color', 'linguini' ),
			'settings' => 'fy_lightbox_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_lightbox_color_background', array(
			'label'    => esc_html__( 'Background Color', 'linguini' ),
			'settings' => 'fy_lightbox_color_background',
			'section'  => 'colors',
		) ) );


		/**
		 *
		 * State
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_state_heading', array(
				'label'   => esc_html__( 'States', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_error_color', array(
			'label'    => esc_html__( 'Error Color', 'linguini' ),
			'settings' => 'fy_error_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_success_color', array(
			'label'    => esc_html__( 'Success Color', 'linguini' ),
			'settings' => 'fy_success_color',
			'section'  => 'colors',
		) ) );

		/**
		 *
		 * Overlay
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_overlay_heading', array(
				'label'   => esc_html__( 'Overlay', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fy_overlay_color', array(
			'label'    => esc_html__( 'Overlay Color', 'linguini' ),
			'settings' => 'fy_overlay_color',
			'section'  => 'colors',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_overlay_opacity', array(
			'label'    => esc_html__( 'Overlay Opacity', 'linguini' ),
			'settings' => 'fy_overlay_opacity',
			'section'  => 'colors',
			'type'     => 'select',
			'choices'  => array(
				'100' => '100%',
				'95'  => '95%',
				'90'  => '90%',
				'85'  => '85%',
				'80'  => '80%',
				'75'  => '75%',
				'70'  => '70%',
				'65'  => '65%',
				'60'  => '60%',
				'55'  => '55%',
				'50'  => '50%',
				'45'  => '45%',
				'40'  => '40%',
				'35'  => '35%',
				'30'  => '30%',
				'25'  => '25%',
				'20'  => '20%',
				'15'  => '15%',
				'10'  => '10%',
				'5'   => '5%',
				'0'   => '0%',
			),
		) ) );

		/**
		 *
		 * Shadows
		 *
		 */

		if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
			$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_shadows_heading', array(
				'label'   => esc_html__( 'Shadows', 'linguini' ),
				'type'    => 'heading',
				'section' => 'colors',
			) ) );
		}
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_style_shadow', array(
			'label'       => esc_html__( 'Shadows', 'linguini' ),
			'description' => esc_html__( 'Enable/disable the shadows.', 'linguini' ),
			'settings'    => 'fy_style_shadow',
			'section'     => 'colors',
			'type'        => 'select',
			'choices'     => array(
				'enabled'  => esc_html__( 'Enabled', 'linguini' ),
				'disabled' => esc_html__( 'Disabled', 'linguini' ),
			),
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_colors' );

}