<?php

/*

Customize About

*/

/*
----------------------------------------------------------------------------------------------------
Add Section
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_section_about' ) ) {

	function linguini_customize_add_section_about( $wp_customize ) {

		$wp_customize->add_section( 'about', array(
			'title'    => esc_html__( 'About', 'linguini' ),
			'priority' => 41,
		) );

	}

	add_action( 'customize_register', 'linguini_customize_add_section_about' );

}

/*
----------------------------------------------------------------------------------------------------
Add Settings
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_settings_about' ) ) {

	function linguini_customize_add_settings_about( $wp_customize ) {

		$wp_customize->add_setting( 'fy_restaurant_headline', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_setting( 'fy_restaurant_description', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_setting( 'fy_restaurant_image', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// Contacts
		$wp_customize->add_setting( 'fy_restaurant_address', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_setting( 'fy_restaurant_map', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_restaurant_phone', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_restaurant_email', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_email',
		) );
		$wp_customize->add_setting( 'fy_restaurant_hours', array(
			'default'           => '',
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_setting( 'fy_restaurant_reservations', array(
			'default'           => linguini_default( 'fy_restaurant_reservations' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_restaurant_price', array(
			'default'           => 'none',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_restaurant_cuisine', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_setting( 'fy_restaurant_currency', array(
			'default'           => linguini_default( 'fy_restaurant_currency' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
	}

	add_action( 'customize_register', 'linguini_customize_add_settings_about' );

}

/*
----------------------------------------------------------------------------------------------------
Add Controls
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'linguini_customize_add_controls_about' ) ) {

	function linguini_customize_add_controls_about( $wp_customize ) {

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_headline', array(
			'label'       => esc_html__( 'Headline', 'linguini' ),
			'description' => esc_html__( 'Fill in the headline of your restaurant.', 'linguini' ),
			'settings'    => 'fy_restaurant_headline',
			'section'     => 'about',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_description', array(
			'label'       => esc_html__( 'Description', 'linguini' ),
			'description' => esc_html__( 'Fill in the short description of your restaurant.', 'linguini' ),
			'settings'    => 'fy_restaurant_description',
			'section'     => 'about',
			'type'        => 'textarea',
		) ) );
		$wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, 'fy_restaurant_image', array(
			'label'       => esc_html__( 'Image', 'linguini' ),
			'description' => esc_html__( 'Upload a restaurant representative image. Required size at least 1200px of width.', 'linguini' ),
			'settings'    => 'fy_restaurant_image',
			'section'     => 'about',
		) ) );

		// Contacts
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_address', array(
			'label'       => esc_html__( 'Address', 'linguini' ),
			'description' => esc_html__( 'Fill in the full address of your restaurant.', 'linguini' ),
			'settings'    => 'fy_restaurant_address',
			'section'     => 'about',
			'type'        => 'textarea',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_map', array(
			'label'       => esc_html__( 'Map', 'linguini' ),
			'description' => esc_html__( 'Fill in the link to Google map.', 'linguini' ),
			'settings'    => 'fy_restaurant_map',
			'section'     => 'about',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_phone', array(
			'label'    => esc_html__( 'Phone', 'linguini' ),
			'settings' => 'fy_restaurant_phone',
			'section'  => 'about',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_email', array(
			'label'    => esc_html__( 'Email', 'linguini' ),
			'settings' => 'fy_restaurant_email',
			'section'  => 'about',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_hours', array(
			'label'       => esc_html__( 'Hours', 'linguini' ),
			'description' => esc_html__( 'Fill in the short opening hours.', 'linguini' ),
			'settings'    => 'fy_restaurant_hours',
			'section'     => 'about',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_cuisine', array(
			'label'       => esc_html__( 'Cuisine', 'linguini' ),
			'description' => esc_html__( 'Fill in the cuisine of the restaurant. Multiple cuisines separate with commas.', 'linguini' ),
			'settings'    => 'fy_restaurant_cuisine',
			'section'     => 'about',
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_price', array(
			'label'    => esc_html__( 'Price Range', 'linguini' ),
			'settings' => 'fy_restaurant_price',
			'section'  => 'about',
			'type'     => 'select',
			'choices'  => array(
				'none' => esc_html__( 'None', 'linguini' ),
				'$'    => '$ ($1 - $10)',
				'$$'   => '$$ ($11 - $30)',
				'$$$'  => '$$$ ($31 - $60)',
				'$$$$' => '$$$$ ($61+)',
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_reservations', array(
			'label'    => esc_html__( 'Accepts Reservations?', 'linguini' ),
			'settings' => 'fy_restaurant_reservations',
			'section'  => 'about',
			'type'     => 'select',
			'choices'  => array(
				'Yes' => esc_html__( 'Yes', 'linguini' ),
				'No'  => esc_html__( 'No', 'linguini' ),
			),
		) ) );
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_restaurant_currency', array(
			'label'       => esc_html__( 'Currency', 'linguini' ),
			'description' => sprintf( wp_kses( __( 'Fill in the currency in standard format <a href="%s" target="_blank">ISO 4217 currency format</a> e.g. "USD".', 'linguini' ), array(
				'a' => array(
					'href'   => array(),
					'target' => array()
				)
			) ), esc_url( 'https://en.wikipedia.org/wiki/ISO_4217' ) ),
			'settings'    => 'fy_restaurant_currency',
			'section'     => 'about',
		) ) );

	}

	add_action( 'customize_register', 'linguini_customize_add_controls_about' );

}