<?php

/*

PhotoSwipe Component

*/

if ( ! function_exists( 'linguini_theme_photoswipe' ) ) {

	function linguini_theme_photoswipe() {

		if ( ! is_admin() ) {
			?>

            <div class="fy-pswp js-pswp pswp" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="pswp__bg"></div>
                <div class="pswp__scroll-wrap">

                    <div class="pswp__container">
                        <div class="pswp__item"></div>
                        <div class="pswp__item"></div>
                        <div class="pswp__item"></div>
                    </div>

                    <div class="pswp__ui pswp__ui--hidden">
                        <div class="pswp__top-bar">

                            <div class="pswp__counter"></div>

                            <button class="pswp__button pswp__button--close" title="<?php esc_attr_e( 'Close (Esc)', 'linguini' ); ?>">
                                <span class="screen-reader-text"><?php esc_html_e( 'Close (Esc)', 'linguini' ); ?></span>
                            </button>
                            <button class="pswp__button pswp__button--fs" title="<?php esc_attr_e( 'Toggle fullscreen', 'linguini' ); ?>">
                                <span class="screen-reader-text"><?php esc_html_e( 'Toggle fullscreen', 'linguini' ); ?></span>
                            </button>
                            <button class="pswp__button pswp__button--zoom" title="<?php esc_attr_e( 'Zoom in/out', 'linguini' ); ?>">
                                <span class="screen-reader-text"><?php esc_html_e( 'Zoom in/out', 'linguini' ); ?></span>
                            </button>

                            <div class="pswp__preloader">
                                <div class="pswp__preloader__icn">
                                    <div class="pswp__preloader__cut">
                                        <div class="pswp__preloader__donut"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button class="pswp__button pswp__button--arrow--left" title="<?php esc_attr_e( 'Previous', 'linguini' ); ?>">
                            <span class="screen-reader-text"><?php esc_html_e( 'Previous', 'linguini' ); ?></span>
                        </button>
                        <button class="pswp__button pswp__button--arrow--right" title="<?php esc_attr_e( 'Next', 'linguini' ); ?>">
                            <span class="screen-reader-text"><?php esc_html_e( 'Next', 'linguini' ); ?></span>
                        </button>

                        <div class="pswp__caption">
                            <div class="pswp__caption__center"></div>
                        </div>
                    </div>
                </div>
            </div>

			<?php
		}

	}

	add_action( 'linguini_footer', 'linguini_theme_photoswipe' );

}
