<?php

/*

Heading Template

*/

// Thumbnail
$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'fy-huge' );
?>

<header class="fy-heading<?php if ( $image ) { ?> fy-heading-with-image<?php } ?>">
	<?php if ( $image ) { ?>
        <div class="fy-heading-image js-lazy" data-src="<?php echo esc_url( $image[0] ); ?>"></div>
	<?php } ?>

    <div class="fy-centerer">

        <h1 class="entry-title" itemprop="name">
			<?php the_title(); ?>
        </h1>

		<?php if ( get_post_type() == 'event' ) { ?>
            <div class="fy-post-date fy-event-date">
				<?php
                if ( function_exists( 'forqy_date_event' ) ) {
	                forqy_date_event( array(
		                'date_start' => forqy_meta( 'fy_event_date' ),
		                'date_end'   => forqy_meta( 'fy_event_date_end' ),
	                ) );
				}

				if ( forqy_meta( 'fy_event_time' ) ) { ?>
                    <span class="fy-post-time"><?php echo forqy_meta( 'fy_event_time' ); ?></span>
				<?php } ?>
            </div>
		<?php } else {
		    if ( get_post_type() == 'post' ) { ?>
                <time class="fy-post-date">
					<?php the_time( get_option( 'date_format' ) ); ?>
                </time>
			<?php }
		} ?>

    </div>
</header>