<?php

/*

Heading Template

*/

// Term Image
$term      = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
$image     = forqy_get_taxonomy_image_src( $term, 'fy-huge' );
?>

<header class="fy-heading <?php if ( $image['src'] ) { ?>fy-heading-with-image<?php } ?>">
	<?php if ( is_tax() && $image['src'] ) { ?>
        <div class="fy-heading-image js-lazy" data-src="<?php echo esc_url( $image['src'] ); ?>"></div>
	<?php } ?>

    <div class="fy-centerer">

        <h1 itemprop="name headline">
			<?php single_term_title(); ?>
        </h1>

		<?php if ( term_description() ) { ?>
            <div class="fy-heading-description">
				<?php echo term_description(); ?>
            </div>
		<?php } ?>

    </div>
</header>