<?php

/*

Heading Template

*/

// Type
$type = 'menu';

// Taxonomy
$taxonomy = 'section';

// Featured Image
$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'fy-huge' );
?>

<header class="fy-heading fy-heading-with-navigation<?php if ( $image ) { ?> fy-heading-with-image<?php } ?>">
	<?php if ( $image ) { ?>
        <div class="fy-heading-image js-lazy" data-src="<?php echo esc_url( $image[0] ); ?>"></div>
	<?php } ?>

    <div class="fy-centerer">

        <h1 itemprop="name">
			<?php the_title(); ?>
        </h1>

    </div>

	<?php if ( get_terms( array( 'taxonomy' => $taxonomy ) ) ) { ?>

        <div class="fy-navigation-menu-container js-sticky-menu">
            <nav class="fy-navigation-menu fy-navigation-menu-horizontal js-navigation-menu">
                <div class="fy-navigation-scroller js-navigation-scroller">
                    <ul>
						<?php
						// Get Terms
						$terms = get_terms( array(
							'taxonomy'   => $taxonomy,
							'orderby'    => 'none',
							'order'      => 'ASC',
							'hide_empty' => 1,
							'parent'     => 0
						) );

						if ( $terms ) {
							foreach ( $terms as $term ) {

								$query = new WP_Query( array(
									'tax_query'      => array(
										array(
											'taxonomy' => $taxonomy,
											'field'    => 'slug',
											'terms'    => $term->slug,
										),
									),
									'post_status'    => 'publish',
									'order'          => 'ASC',
									'posts_per_page' => - 1
								) );

								if ( $query->have_posts() ) { ?>
                                    <li>
                                        <a href="#<?php echo esc_attr( $term->slug ); ?>">
											<?php echo esc_html( $term->name ); ?>
                                        </a>
                                    </li>

								<?php }

								wp_reset_postdata();
							}
						} ?>
                    </ul>
                </div>
            </nav>
        </div>

	<?php } ?>
</header>
