<?php

/*

Index Heading Template

*/

// Get Blog Page Title
$title = get_the_title( get_option( 'page_for_posts', true ) );

// Featured Image
$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_option( 'page_for_posts' ) ), 'fy-huge' );
?>

<header class="fy-heading<?php if ( $image ) { ?> fy-heading-with-image<?php } ?>">
	<?php if ( $image ) { ?>
        <div class="fy-heading-image js-lazy" data-src="<?php echo esc_url( $image[0] ); ?>"></div>
	<?php } ?>

    <div class="fy-centerer">

	    <?php if ( $title ) { ?>
            <h1><?php echo esc_html( $title ); ?></h1>
	    <?php } ?>

    </div>
</header>