<!DOCTYPE html>
<html id="top" <?php language_attributes(); ?>>

<head>

    <meta charset="<?php bloginfo( 'charset' ); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="theme-color" content="<?php echo esc_attr( get_theme_mod( 'fy_background_color', linguini_default( 'fy_background_color' ) ) ); ?>">

    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>

<ul id="skip-links" class="fy-skip-links">
    <li><a href="#navigation"><?php esc_html_e( 'Skip to Navigation', 'linguini' ); ?></a></li>
    <li><a href="#content"><?php esc_html_e( 'Skip to Content', 'linguini' ); ?></a></li>
    <li><a href="#footer"><?php esc_html_e( 'Skip to Footer', 'linguini' ); ?></a></li>
</ul>

<div class="fy-container">

    <div class="fy-canvas js-sticky-container">

		<?php get_template_part( 'header', 'default' ); ?>
