<?php

/*

Standard Content Template

*/

// Post
$post_class = array( 'fy-post', 'fy-post-category', 'fy-post-standard' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>

    <div class="fy-flex-container">

		<?php if ( has_post_thumbnail() ) { ?>
            <div class="fy-flex-column-100">
				<?php get_template_part( 'templates/image/thumbnail' ); ?>
            </div>
		<?php } ?>

        <header class="fy-post-header fy-flex-column-100">
            <h2>
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <?php the_title(); ?>
                </a>
            </h2>
        </header>

        <div class="fy-flex-column-auto">
	        <?php get_template_part( 'templates/post/excerpt' ); ?>

            <footer class="fy-post-footer fy-flex-container fy-flex-container-center">
                <div class="fy-flex-column-auto fy-flex-column-phone-100">
					<?php if ( function_exists( 'linguini_post_meta' ) ) {
						linguini_post_meta();
					} ?>
                </div>

                <div class="fy-flex-column fy-flex-column-phone-100">
                    <?php get_template_part('templates/post/more'); ?>
                </div>
            </footer>

            <div class="fy-divider"></div>

        </div>

    </div>

</article>
