<?php

/*

Standard Content Template

*/

// Post
$post_class = array( 'fy-post', 'fy-post-category', 'fy-post-search' );

// Thumbnail
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive js-lazy' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container fy-flex-container-center">

		<?php if ( has_post_thumbnail() ) { ?>
            <div class="fy-flex-column-20">
				<?php get_template_part( 'templates/image/thumbnail' ); ?>
            </div>
		<?php } ?>

        <div class="fy-flex-column-auto">

            <header class="fy-post-header">
                <h2 itemprop="name headline">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" itemprop="url">
                        <?php the_title(); ?>
                    </a>
                </h2>
            </header>

            <div class="fy-post-excerpt" itemprop="description">
				<?php the_excerpt(); ?>
            </div>
        </div>

    </div>
</article>