<?php

/*

Menu Content Template

*/

global $index;

// Post
$post_class = array( 'fy-post', 'fy-post-menu' );

// Thumbnail
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive' );
$thumbnail_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );

// Vars
$prices = array_filter( forqy_meta( 'fy_menu_price' ) );
$badges = array_filter( forqy_meta( 'fy_menu_badges' ) );

// Prices
if ( ! empty( $prices ) ) {
	foreach ( $prices as $price => $item ) {
		if ( preg_replace( '/\s/', '', $item ) === '' ) {
			unset( $prices[ $price ] );
		}
	}
}

// Badges
if ( ! empty( $badges ) ) {
	foreach ( $badges as $badge => $item ) {
		if ( preg_replace( '/\s/', '', $item ) === '' ) {
			unset( $badge[ $badge ] );
		}
	}
}

// Post Class

if ( ! has_post_thumbnail() ) {
	array_push( $post_class, 'fy-no-thumbnail' );
}
if ( ! get_the_content() || empty( $post->post_excerpt ) ) {
	array_push( $post_class, 'fy-no-content' );
}
if ( ! has_term( '', 'ingredient' ) ) {
	array_push( $post_class, 'fy-no-ingredient' );
}
if ( empty( $badges ) ) {
	array_push( $post_class, 'fy-no-badge' );
}
if ( empty( $prices ) ) {
	array_push( $post_class, 'fy-no-prices' );
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container<?php if ( is_active_sidebar( 'menu' ) ) { ?> fy-flex-container-center<?php } ?>">

		<?php if ( has_post_thumbnail() ) { ?>
            <div class="<?php if ( is_active_sidebar( 'menu' ) ) { ?> fy-flex-column-25<?php } else { ?> fy-flex-column-30<?php } ?> fy-flex-column-phone-100">

                <figure class="fy-post-image">
					<?php if ( get_theme_mod( 'fy_menu_single' ) != 'enabled' ) { ?>
                        <a href="<?php echo esc_url( $thumbnail_image[0] ); ?>"
                           class="js-lazy-parent js-image"
                           title="<?php the_title(); ?>"
                           data-size="<?php echo esc_attr( $thumbnail_image[1] ); ?>x<?php echo esc_attr( $thumbnail_image[2] ); ?>"
                           data-index="<?php echo esc_attr( $index ++ ); ?>">
							<?php the_post_thumbnail( 'fy-medium-fixed', $thumbnail_attr ); ?>

							<?php get_template_part( 'templates/element/loading' ); ?>
                            <meta itemprop="image" content="<?php the_post_thumbnail_url( 'fy-medium-fixed' ); ?>">
                        </a>
					<?php } else { ?>
                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="js-lazy-parent">
							<?php the_post_thumbnail( 'fy-medium-fixed', $thumbnail_attr ); ?>

							<?php get_template_part( 'templates/element/loading' ); ?>
                        </a>
					<?php } ?>

                    <figcaption itemprop="caption description" class="fy-post-image-caption fy-hide">
                        <small class="pswp__caption-terms">
							<?php echo get_the_term_list( $post->ID, 'section' ); ?>
                        </small>
                        <strong class="pswp__caption-title">
							<?php the_title(); ?>
                        </strong>
                        <small>
							<?php if ( ! empty( $prices ) ) { ?>
								<?php echo esc_html( implode( ', ', $prices ) ); ?>
							<?php } ?>
                        </small>
                    </figcaption>
                </figure>

            </div>
		<?php } ?>

        <div class="fy-flex-column-auto">

            <header class="fy-post-header">

                <div class="fy-flex-container fy-flex-container-center fy-flex-gutter-small">

                    <div class="fy-flex-column-auto fy-flex-column-phone-100">
                        <h3 class="entry-title" itemprop="name">
							<span>
								<?php if ( get_theme_mod( 'fy_menu_single' ) != 'enabled' ) { ?>
									<?php the_title(); ?>
								<?php } else { ?>
                                    <a href="<?php the_permalink(); ?>" itemprop="url"><?php the_title(); ?></a>
								<?php } ?>
							</span>
                        </h3>
                    </div>

					<?php if ( ! empty( $prices ) ) { ?>
                        <div class="fy-flex-column fy-flex-column-phone-100">
                            <div class="fy-post-prices fy-align-right">
								<?php echo implode( ', ', $prices ); ?>
                            </div>
                        </div>
					<?php } ?>

                </div>

                <div class="fy-post-line"></div>
            </header>

            <div class="fy-post-author fy-hide vcard author">
                <span class="fn"><?php echo get_bloginfo( 'name' ); ?></span>
            </div>

            <time class="fy-post-date fy-hide date updated" itemprop="dateCreated"
                  datetime="<?php the_time( 'Y-m-d' ); ?>">
				<?php the_time( get_option( 'date_format' ) ); ?></time>

			<?php if ( has_excerpt() ) { ?>
                <div class="fy-post-excerpt" itemprop="description">
					<?php the_excerpt(); ?>
                </div>
			<?php } else if ( get_the_content() ) { ?>
                <div class="fy-post-content fy-content" itemprop="articleBody">
					<?php the_content(); ?>
                </div>
			<?php } ?>

			<?php if ( has_term( '', 'ingredient' ) || ! empty( $badges ) ) { ?>

                <div class="fy-flex-container fy-flex-container-top">

					<?php if ( has_term( '', 'ingredient' ) ) { ?>
                        <div class="fy-flex-column-auto fy-flex-column-phone-100">
                            <div class="fy-post-taxonomies">
								<?php if ( get_theme_mod( 'fy_menu_filter_by_ingredients' ) == 'disabled' ) { ?>
									<?php linguini_terms_post( $post->ID, 'ingredient', 0 ); ?>
								<?php } else { ?>
									<?php linguini_terms_post( $post->ID, 'ingredient', 1 ); ?>
								<?php } ?>
                            </div>
                        </div>
					<?php } ?>

					<?php if ( ! empty( $badges ) ) { ?>
                        <div class="<?php if ( has_term( '', 'ingredient' ) ) { ?>fy-flex-column<?php } else { ?>fy-flex-column-auto<?php } ?>  fy-flex-column-phone-100">
                            <div class="fy-post-badges">
                                <ul>
									<?php foreach ( $badges as $badge ) { ?>
                                        <li><?php echo esc_html( $badge ); ?></li>
									<?php } ?>
                                </ul>
                            </div>
                        </div>
					<?php } ?>

                </div>

			<?php } ?>

        </div>

    </div>
</article>
